/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.factory;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.api.annotation.ManagementRuntimeRef;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.managed.spi.factory.RuntimeComponentNameTransformer;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractInstanceClassFactory<T extends Serializable>
implements InstanceClassFactory<T> {
    private Configuration configuration = new PropertyConfiguration();
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private Map<TypeInfo, RuntimeComponentNameTransformer> transformers = new WeakHashMap<TypeInfo, RuntimeComponentNameTransformer>();
    private ManagedObjectFactory mof = new AbstractManagedObjectFactory();

    public Map<TypeInfo, RuntimeComponentNameTransformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(Map<TypeInfo, RuntimeComponentNameTransformer> transformers) {
        this.transformers = transformers;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public MetaValueFactory getMetaValueFactory() {
        return this.metaValueFactory;
    }

    public void setMetaValueFactory(MetaValueFactory metaValueFactory) {
        this.metaValueFactory = metaValueFactory;
    }

    public ManagedObjectFactory getMof() {
        return this.mof;
    }

    public void setMof(ManagedObjectFactory mof) {
        this.mof = mof;
    }

    @Override
    public Class<? extends Serializable> getManagedObjectClass(T attachment) throws ClassNotFoundException {
        return attachment.getClass();
    }

    @Override
    public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, T attachment, MetaValue value) {
        String name;
        PropertyInfo propertyInfo;
        ManagementRuntimeRef componentRef;
        if (beanInfo != null && property != null && value != null && (componentRef = (ManagementRuntimeRef)(propertyInfo = beanInfo.getProperty(name = this.getPropertyName(property))).getUnderlyingAnnotation(ManagementRuntimeRef.class)) != null) {
            Object original = this.unwrapValue(beanInfo, property, value);
            try {
                Class<? extends RuntimeComponentNameTransformer> tClass = componentRef.transformer();
                RuntimeComponentNameTransformer transformer = tClass != ManagementRuntimeRef.DEFAULT_NAME_TRANSFORMER.class ? this.getComponentNameTransformer(this.configuration.getTypeInfo(tClass)) : this.getComponentNameTransformer(propertyInfo.getType());
                return transformer != null ? transformer.transform(original) : original;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return null;
    }

    @Override
    public Class<? extends Serializable> getManagedObjectClass(Object instance) {
        Serializable s = (Serializable)instance;
        return s.getClass();
    }

    @Override
    public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, T object) {
        CollectionMetaType collectionType;
        Object value;
        String name = this.getPropertyName(property);
        PropertyInfo propertyInfo = beanInfo.getProperty(name);
        try {
            value = propertyInfo.get(object);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting property " + name + " for " + object.getClass().getName(), t);
        }
        if (value == null) {
            return null;
        }
        MetaType propertyType = property.getMetaType();
        if (AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE == propertyType) {
            if (!(value instanceof Serializable)) {
                throw new IllegalStateException("Object is not serializable: " + value.getClass().getName());
            }
            ManagementObjectRef ref = (ManagementObjectRef)property.getAnnotations().get(ManagementObjectRef.class.getName());
            String moName = ref != null ? ref.name() : value.getClass().getName();
            String moNameType = ref != null ? ref.type() : "";
            ManagedObject mo = this.mof.initManagedObject((Serializable)value, moName, moNameType);
            return new GenericValueSupport(AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Serializable)mo);
        }
        if (propertyType.isArray()) {
            ArrayMetaType arrayType = (ArrayMetaType)ArrayMetaType.class.cast(propertyType);
            if (AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE == arrayType.getElementType()) {
                Collection<?> cvalue = this.getAsCollection(value);
                ArrayMetaType moType = new ArrayMetaType(1, (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE);
                ArrayValueSupport moArrayValue = new ArrayValueSupport(moType);
                ArrayList<GenericValueSupport> tmp = new ArrayList<GenericValueSupport>();
                for (Object element : cvalue) {
                    ManagedObject mo = this.mof.initManagedObject((Serializable)element, null, null);
                    tmp.add(new GenericValueSupport(AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Serializable)mo));
                }
                GenericValueSupport[] mos = new GenericValueSupport[tmp.size()];
                moArrayValue.setValue((Object)tmp.toArray(mos));
                return moArrayValue;
            }
        } else if (propertyType.isCollection() && AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE == (collectionType = (CollectionMetaType)CollectionMetaType.class.cast(propertyType)).getElementType()) {
            Collection<?> cvalue = this.getAsCollection(value);
            ArrayList<GenericValueSupport> tmp = new ArrayList<GenericValueSupport>();
            for (Object element : cvalue) {
                ManagedObject mo = this.mof.initManagedObject((Serializable)element, null, null);
                tmp.add(new GenericValueSupport(AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Serializable)mo));
            }
            GenericValueSupport[] mos = new GenericValueSupport[tmp.size()];
            CollectionMetaType moType = new CollectionMetaType(propertyType.getClassName(), (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE);
            return new CollectionValueSupport(moType, (MetaValue[])tmp.toArray(mos));
        }
        return this.metaValueFactory.create(value, propertyInfo.getType());
    }

    @Override
    public void setValue(BeanInfo beanInfo, ManagedProperty property, T object, MetaValue value) {
        String name = this.getPropertyName(property);
        PropertyInfo propertyInfo = beanInfo.getProperty(name);
        Object unwrapValue = this.unwrapValue(beanInfo, property, value);
        try {
            this.setValue(beanInfo, propertyInfo, object, unwrapValue);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeComponentNameTransformer getComponentNameTransformer(TypeInfo type) throws Throwable {
        Map<TypeInfo, RuntimeComponentNameTransformer> map = this.transformers;
        synchronized (map) {
            RuntimeComponentNameTransformer transformer = this.transformers.get(type);
            if (transformer != null) {
                return transformer;
            }
            TypeInfo rcntType = this.configuration.getTypeInfo(RuntimeComponentNameTransformer.class);
            if (rcntType.isAssignableFrom(type)) {
                BeanInfo beanInfo = this.configuration.getBeanInfo(type);
                RuntimeComponentNameTransformer newTransformer = (RuntimeComponentNameTransformer)beanInfo.newInstance();
                this.transformers.put(type, newTransformer);
                return newTransformer;
            }
            return null;
        }
    }

    protected Object unwrapValue(BeanInfo beanInfo, ManagedProperty property, MetaValue value) {
        String name = this.getPropertyName(property);
        PropertyInfo propertyInfo = beanInfo.getProperty(name);
        Object unwrapValue = this.metaValueFactory.unwrap(value, propertyInfo.getType());
        return unwrapValue;
    }

    protected void setValue(BeanInfo beanInfo, PropertyInfo propertyInfo, Object object, Object unwrapValue) throws Throwable {
        propertyInfo.set(object, unwrapValue);
    }

    protected Collection<?> getAsCollection(Object value) {
        if (value.getClass().isArray()) {
            return Arrays.asList(value);
        }
        if (value instanceof Collection) {
            return (Collection)Collection.class.cast(value);
        }
        return null;
    }

    protected String getPropertyName(ManagedProperty property) {
        String name = property.getMappedName();
        if (name == null) {
            property.getName();
        }
        return name;
    }
}

