/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.reflect.AnnotatedElement;
import org.jboss.metadata.annotation.creator.AbstractComponentProcessor;
import org.jboss.metadata.annotation.creator.DeclareRolesProcessor;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.web.MultipartConfigProcessor;
import org.jboss.metadata.annotation.creator.web.RunAsProcessor;
import org.jboss.metadata.annotation.creator.web.ServletSecurityProcessor;
import org.jboss.metadata.annotation.creator.web.WebFilterProcessor;
import org.jboss.metadata.annotation.creator.web.WebListenerProcessor;
import org.jboss.metadata.annotation.creator.web.WebServletProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.web.spec.AnnotationsMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WebComponentProcessor
extends AbstractComponentProcessor<WebMetaData>
implements Processor<WebMetaData, Class<?>> {
    public WebComponentProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new WebFilterProcessor(finder));
        this.addTypeProcessor(new WebListenerProcessor(finder));
        this.addTypeProcessor(new WebServletProcessor(finder));
        this.addTypeProcessor(new RunAsProcessor(finder));
        this.addTypeProcessor((Processor)new DeclareRolesProcessor(finder));
        this.addTypeProcessor(new MultipartConfigProcessor(finder));
        this.addTypeProcessor(new ServletSecurityProcessor(finder));
    }

    public void process(WebMetaData metaData, Class<?> type) {
        super.process((Object)metaData, type);
        EnvironmentRefsGroupMetaData env = metaData.getJndiEnvironmentRefsGroup();
        if (env == null) {
            env = new EnvironmentRefsGroupMetaData();
            metaData.setJndiEnvironmentRefsGroup(env);
        }
        super.process(env, type);
        AnnotationsMetaData annotations = metaData.getAnnotations();
        if (annotations == null) {
            annotations = new AnnotationsMetaData();
            metaData.setAnnotations(annotations);
        }
        super.processClass((Object)annotations, type);
        SecurityRolesMetaData securityRoles = metaData.getSecurityRoles();
        if (securityRoles == null) {
            securityRoles = new SecurityRolesMetaData();
            metaData.setSecurityRoles(securityRoles);
        }
        super.processClass((Object)securityRoles, type);
    }
}

