/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;

public class FilterMappingMetaDataParser
extends MetaDataElementParser {
    public static FilterMappingMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        FilterMappingMetaData filterMapping = new FilterMappingMetaData();
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (FilterMappingMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    filterMapping.setId(value);
                    continue block11;
                }
                default: {
                    throw FilterMappingMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FILTER_NAME: {
                    filterMapping.setFilterName(FilterMappingMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block12;
                }
                case URL_PATTERN: {
                    List<String> urlPatterns = filterMapping.getUrlPatterns();
                    if (urlPatterns == null) {
                        urlPatterns = new ArrayList<String>();
                        filterMapping.setUrlPatterns(urlPatterns);
                    }
                    urlPatterns.add(FilterMappingMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block12;
                }
                case SERVLET_NAME: {
                    List<String> servletNames = filterMapping.getServletNames();
                    if (servletNames == null) {
                        servletNames = new ArrayList<String>();
                        filterMapping.setServletNames(servletNames);
                    }
                    servletNames.add(FilterMappingMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block12;
                }
                case DISPATCHER: {
                    List<DispatcherType> dispatchers = filterMapping.getDispatchers();
                    if (dispatchers == null) {
                        dispatchers = new ArrayList<DispatcherType>();
                        filterMapping.setDispatchers(dispatchers);
                    }
                    try {
                        dispatchers.add(DispatcherType.valueOf(FilterMappingMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                        continue block12;
                    }
                    catch (IllegalArgumentException e) {
                        throw FilterMappingMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)e);
                    }
                }
            }
            throw FilterMappingMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return filterMapping;
    }
}

