/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderDomain
extends BaseClassLoaderDomain
implements Loader {
    private static final Logger log = Logger.getLogger(ClassLoaderDomain.class);
    private String name;
    private ParentPolicy parentPolicy = ParentPolicy.BEFORE;
    private Loader parent;

    public ClassLoaderDomain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.fixUpParent();
    }

    public String getName() {
        return this.name;
    }

    public ParentPolicy getParentPolicy() {
        return this.parentPolicy;
    }

    public void setParentPolicy(ParentPolicy parentPolicy) {
        if (parentPolicy == null) {
            throw new IllegalArgumentException("Null parent policy");
        }
        this.parentPolicy = parentPolicy;
    }

    public Loader getParent() {
        return this.parent;
    }

    public void setParent(Loader parent) {
        this.parent = parent;
        this.fixUpParent();
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        builder.append("name=").append(this.getName());
        builder.append(" parentPolicy=").append(this.getParentPolicy());
        builder.append(" parent=");
        Loader parent = this.getParent();
        if (parent != null) {
            builder.append(parent);
        } else {
            builder.append(this.getParentClassLoader());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{").append(this.name).append('}');
        return builder.toString();
    }

    @Override
    protected Loader findBeforeLoader(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.findLoaderFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected Loader findAfterLoader(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.findLoaderFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected Loader findLoaderFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not loading from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " load from parent " + name + " parent=" + this.parent));
        }
        if (parentLoader instanceof ClassLoaderDomain) {
            ClassLoaderDomain parentDomain = (ClassLoaderDomain)parentLoader;
            return parentDomain.findLoader(name);
        }
        if (parentLoader.getResource(name) != null) {
            return parentLoader;
        }
        return null;
    }

    @Override
    protected URL beforeGetResource(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.getResourceFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected URL afterGetResource(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.getResourceFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected URL getResourceFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting resource from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " get resource from parent " + name + " parent=" + parentLoader));
        }
        URL result = parentLoader.getResource(name);
        if (trace) {
            if (result != null) {
                log.trace((Object)(this + " got resource from parent " + name + " parent=" + parentLoader + " " + result));
            } else {
                log.trace((Object)(this + " resource not found in parent " + name + " parent=" + parentLoader));
            }
        }
        return result;
    }

    @Override
    protected void beforeGetResources(String name, Set<URL> urls) throws IOException {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            this.getResourcesFromParent(name, urls);
        } else if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
    }

    @Override
    protected void afterGetResources(String name, Set<URL> urls) throws IOException {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            this.getResourcesFromParent(name, urls);
        } else if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
    }

    protected void getResourcesFromParent(String name, Set<URL> urls) throws IOException {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting resources from non-existant parent"));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " get resources from parent " + name + " parent=" + parentLoader));
        }
        parentLoader.getResources(name, urls);
    }

    private void fixUpParent() {
        ClassLoader classLoader;
        if (this.parent == null && (classLoader = this.getParentClassLoader()) != null) {
            this.parent = AccessController.doPrivileged(new PrivilegedAction<Loader>(){

                @Override
                public Loader run() {
                    return new ClassLoaderToLoaderAdapter(classLoader);
                }
            });
        }
    }
}

