/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderSystem;
import org.jboss.classloader.spi.base.BaseDelegateLoader;
import org.jboss.classloader.spi.base.ClassLoaderInformation;
import org.jboss.classloader.spi.base.ClassLoaderManager;
import org.jboss.classloader.spi.base.ClassLoadingTask;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClassLoaderDomain
implements Loader {
    private static final Logger log = Logger.getLogger(BaseClassLoaderDomain.class);
    private BaseClassLoaderSystem system;
    private List<ClassLoaderInformation> classLoaders = new CopyOnWriteArrayList<ClassLoaderInformation>();
    private Map<ClassLoader, ClassLoaderInformation> infos = new ConcurrentHashMap<ClassLoader, ClassLoaderInformation>();
    private Map<String, List<ClassLoaderInformation>> classLoadersByPackageName = new ConcurrentHashMap<String, List<ClassLoaderInformation>>();
    private Map<String, Loader> globalClassCache = new ConcurrentHashMap<String, Loader>();
    private Set<String> globalClassBlackList = new CopyOnWriteArraySet<String>();
    private Map<String, URL> globalResourceCache = new ConcurrentHashMap<String, URL>();
    private Set<String> globalResourceBlackList = new CopyOnWriteArraySet<String>();
    private int order = 0;

    public void flushCaches() {
        this.globalClassCache.clear();
        this.globalClassBlackList.clear();
        this.globalResourceCache.clear();
        this.globalResourceBlackList.clear();
    }

    synchronized BaseClassLoaderSystem getClassLoaderSystem() {
        return this.system;
    }

    synchronized void setClassLoaderSystem(BaseClassLoaderSystem system) {
        if (system == null) {
            this.shutdownDomain();
        }
        this.system = system;
    }

    protected void shutdownDomain() {
        Iterator<ClassLoaderInformation> iterator;
        log.debug((Object)(this.toLongString() + " shutdown!"));
        while ((iterator = this.classLoaders.iterator()).hasNext()) {
            while (iterator.hasNext()) {
                ClassLoaderInformation info = iterator.next();
                if (info == null) continue;
                this.unregisterClassLoader(info.getClassLoader());
            }
        }
        this.flushCaches();
    }

    public boolean hasClassLoaders() {
        return !this.classLoaders.isEmpty();
    }

    protected byte[] transform(ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        BaseClassLoaderSystem system = this.getClassLoaderSystem();
        if (system != null) {
            return system.transform(classLoader, className, byteCode, protectionDomain);
        }
        return byteCode;
    }

    Class<?> loadClass(BaseClassLoader classLoader, String name, boolean allExports) throws ClassNotFoundException {
        ClassLoaderPolicy policy;
        ClassLoader hack;
        boolean trace = log.isTraceEnabled();
        String path = ClassLoaderUtils.classNameToPath(name);
        Loader loader = this.findLoader(classLoader, path, allExports);
        if (loader != null) {
            Thread thread = Thread.currentThread();
            ClassLoadingTask task = new ClassLoadingTask(name, classLoader, thread);
            ClassLoaderManager.scheduleTask(task, loader, false);
            return ClassLoaderManager.process(thread, task);
        }
        if (classLoader != null && (hack = ((BaseClassLoaderPolicy)(policy = classLoader.getPolicy())).isJDKRequest(name)) != null) {
            Class<?> result;
            if (trace) {
                log.trace((Object)(this + " trying to load " + name + " using hack " + hack));
            }
            if ((result = hack.loadClass(name)) != null) {
                if (trace) {
                    log.trace((Object)(this + " loaded from hack " + hack + " " + ClassLoaderUtils.classToString(result)));
                }
                return result;
            }
        }
        return null;
    }

    protected Loader findLoader(String name) {
        return this.findLoader(null, name, true);
    }

    Loader findLoader(BaseClassLoader classLoader, String name, boolean allExports) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " findLoader " + name + " classLoader=" + classLoader + " allExports=" + allExports));
        }
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        Loader loader = this.findBeforeLoader(name);
        if (loader != null) {
            return loader;
        }
        ClassLoaderInformation info = null;
        ClassLoaderPolicy policy = null;
        if (classLoader != null) {
            info = this.infos.get(classLoader);
            policy = classLoader.getPolicy();
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            loader = this.findLoaderInExports(classLoader, name, trace);
            if (loader != null) {
                return loader;
            }
        } else if (trace) {
            log.trace((Object)(this + " not loading " + name + " from all exports"));
        }
        if (info != null && (loader = this.findLoaderInImports(info, name, trace)) != null) {
            return loader;
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to load " + name + " from requesting " + classLoader));
            }
            if (classLoader.getResourceLocally(name) != null) {
                return classLoader.getLoader();
            }
        }
        return this.findAfterLoader(name);
    }

    URL getResource(BaseClassLoader classLoader, String name, boolean allExports) {
        boolean trace = log.isTraceEnabled();
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        URL result = this.beforeGetResource(name);
        if (result != null) {
            return result;
        }
        ClassLoaderInformation info = null;
        ClassLoaderPolicy policy = null;
        if (classLoader != null) {
            policy = classLoader.getPolicy();
            info = this.infos.get(classLoader);
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            result = this.getResourceFromExports(classLoader, name, trace);
            if (result != null) {
                return result;
            }
        } else if (trace) {
            log.trace((Object)(this + " not getting resource " + name + " from all exports"));
        }
        if (info != null && (result = this.getResourceFromImports(info, name, trace)) != null) {
            return result;
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to get resource " + name + " from requesting " + classLoader));
            }
            if ((result = classLoader.getResourceLocally(name)) != null) {
                if (trace) {
                    log.trace((Object)(this + " got resource from requesting " + classLoader + " " + result));
                }
                return result;
            }
        }
        if ((result = this.afterGetResource(name)) != null) {
            return result;
        }
        return null;
    }

    void getResources(BaseClassLoader classLoader, String name, Set<URL> urls, boolean allExports) throws IOException {
        boolean trace = log.isTraceEnabled();
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        this.beforeGetResources(name, urls);
        ClassLoaderInformation info = null;
        ClassLoaderPolicy policy = null;
        if (classLoader != null) {
            policy = classLoader.getPolicy();
            info = this.infos.get(classLoader);
            if (((BaseClassLoaderPolicy)policy).isImportAll()) {
                allExports = true;
            }
        }
        if (allExports) {
            this.getResourcesFromExports(classLoader, name, urls, trace);
        } else if (trace) {
            log.trace((Object)(this + " not getting resource " + name + " from all exports"));
        }
        if (info != null) {
            this.getResourcesFromImports(info, name, urls, trace);
        }
        if (classLoader != null) {
            if (trace) {
                log.trace((Object)(this + " trying to get resources " + name + " from requesting " + classLoader));
            }
            classLoader.getResourcesLocally(name, urls);
        }
        this.afterGetResources(name, urls);
    }

    private Loader findLoaderInExports(BaseClassLoader classLoader, String name, boolean trace) {
        Loader loader = this.globalClassCache.get(name);
        if (loader != null) {
            if (trace) {
                log.trace((Object)(this + " found in global class cache " + name));
            }
            return loader;
        }
        if (this.globalClassBlackList.contains(name)) {
            if (trace) {
                log.trace((Object)(this + " class is black listed " + name));
            }
            return null;
        }
        boolean canCache = true;
        boolean canBlackList = true;
        String packageName = ClassLoaderUtils.getResourcePackageName(name);
        List<ClassLoaderInformation> list = this.classLoadersByPackageName.get(packageName);
        if (trace) {
            log.trace((Object)(this + " trying to load " + name + " from all exports of package " + packageName + " " + list));
        }
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader exported = info.getExported();
                BaseClassLoaderPolicy loaderPolicy = exported.getPolicy();
                if (!loaderPolicy.isCachable()) {
                    canCache = false;
                }
                if (!loaderPolicy.isBlackListable()) {
                    canBlackList = false;
                }
                if (exported.getResource(name) == null) continue;
                if (canCache) {
                    this.globalClassCache.put(name, exported);
                }
                return exported;
            }
        }
        if (canBlackList) {
            this.globalClassBlackList.add(name);
        }
        return null;
    }

    private URL getResourceFromExports(BaseClassLoader classLoader, String name, boolean trace) {
        URL result = this.globalResourceCache.get(name);
        if (result != null && trace) {
            log.trace((Object)(this + " got resource from cache " + name));
        }
        if (this.globalResourceBlackList.contains(name)) {
            if (trace) {
                log.trace((Object)(this + " resource is black listed, not looking at exports " + name));
            }
            return null;
        }
        boolean canCache = true;
        boolean canBlackList = true;
        String packageName = ClassLoaderUtils.getResourcePackageName(name);
        List<ClassLoaderInformation> list = this.classLoadersByPackageName.get(packageName);
        if (trace) {
            log.trace((Object)(this + " trying to get resource " + name + " from all exports " + list));
        }
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader loader = info.getExported();
                BaseClassLoaderPolicy loaderPolicy = loader.getPolicy();
                if (!loaderPolicy.isCachable()) {
                    canCache = false;
                }
                if (!loaderPolicy.isBlackListable()) {
                    canBlackList = false;
                }
                if ((result = loader.getResource(name)) == null) continue;
                if (canCache) {
                    this.globalResourceCache.put(name, result);
                }
                return result;
            }
        }
        if (canBlackList) {
            this.globalResourceBlackList.add(name);
        }
        return null;
    }

    void getResourcesFromExports(BaseClassLoader classLoader, String name, Set<URL> urls, boolean trace) throws IOException {
        String packageName = ClassLoaderUtils.getResourcePackageName(name);
        List<ClassLoaderInformation> list = this.classLoadersByPackageName.get(packageName);
        if (trace) {
            log.trace((Object)(this + " trying to get resources " + name + " from all exports " + list));
        }
        if (list != null && !list.isEmpty()) {
            for (ClassLoaderInformation info : list) {
                BaseDelegateLoader loader = info.getExported();
                loader.getResources(name, urls);
            }
        }
    }

    Loader findLoaderInImports(ClassLoaderInformation info, String name, boolean trace) {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not loading " + name + " from imports it has no delegates"));
            }
            return null;
        }
        Loader loader = info.getCachedLoader(name);
        if (loader != null) {
            if (trace) {
                log.trace((Object)(this + " found in import cache " + name));
            }
            return loader;
        }
        if (info.isBlackListedClass(name)) {
            if (trace) {
                log.trace((Object)(this + " class is black listed in imports " + name));
            }
            return null;
        }
        for (DelegateLoader delegateLoader : delegates) {
            if (trace) {
                log.trace((Object)(this + " trying to load " + name + " from import " + delegateLoader + " for " + info.getClassLoader()));
            }
            if (delegateLoader.getResource(name) == null) continue;
            info.cacheLoader(name, delegateLoader);
            return delegateLoader;
        }
        info.blackListClass(name);
        return null;
    }

    private URL getResourceFromImports(ClassLoaderInformation info, String name, boolean trace) {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not getting resource " + name + " from imports it has no delegates"));
            }
            return null;
        }
        URL url = info.getCachedResource(name);
        if (url != null) {
            if (trace) {
                log.trace((Object)(this + " found resource in import cache " + name));
            }
            return url;
        }
        if (info.isBlackListedResource(name)) {
            if (trace) {
                log.trace((Object)(this + " resource is black listed in imports " + name));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " trying to get resource " + name + " from imports " + delegates + " for " + info.getClassLoader()));
        }
        for (DelegateLoader delegateLoader : delegates) {
            URL result = delegateLoader.getResource(name);
            if (result == null) continue;
            info.cacheResource(name, result);
            return result;
        }
        info.blackListResource(name);
        return null;
    }

    void getResourcesFromImports(ClassLoaderInformation info, String name, Set<URL> urls, boolean trace) throws IOException {
        List<? extends DelegateLoader> delegates = info.getDelegates();
        if (delegates == null || delegates.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " not getting resource " + name + " from imports it has no delegates"));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " trying to get resources " + name + " from imports " + delegates + " for " + info.getClassLoader()));
        }
        for (DelegateLoader delegateLoader : delegates) {
            delegateLoader.getResources(name, urls);
        }
    }

    protected abstract Loader findBeforeLoader(String var1);

    protected abstract Loader findAfterLoader(String var1);

    protected abstract void beforeGetResources(String var1, Set<URL> var2) throws IOException;

    protected abstract void afterGetResources(String var1, Set<URL> var2) throws IOException;

    protected abstract URL beforeGetResource(String var1);

    protected abstract URL afterGetResource(String var1);

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.loadClass(null, name, true);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    Class<?> loadClass(BaseClassLoader classLoader, String name) throws ClassNotFoundException {
        return this.loadClass(classLoader, name, false);
    }

    @Override
    public URL getResource(String name) {
        return this.getResource(null, name, true);
    }

    URL getResource(BaseClassLoader classLoader, String name) {
        return this.getResource(classLoader, name, false);
    }

    @Override
    public void getResources(String name, Set<URL> urls) throws IOException {
        this.getResources(null, name, urls, true);
    }

    void getResources(BaseClassLoader classLoader, String name, Set<URL> urls) throws IOException {
        this.getResources(classLoader, name, urls, false);
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{");
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void toLongString(StringBuilder builder) {
    }

    protected void beforeRegisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected void afterRegisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected void beforeUnregisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected void afterUnregisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
    }

    protected ClassLoader getParentClassLoader() {
        return this.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerClassLoader(BaseClassLoader classLoader) {
        log.debug((Object)(this + " registerClassLoader " + classLoader.toLongString()));
        if (this.getClassLoaderSystem() == null) {
            throw new IllegalStateException("Domain is not registered with a classloader system: " + this.toLongString());
        }
        try {
            this.beforeRegisterClassLoader(classLoader, classLoader.getPolicy());
        }
        catch (Throwable t) {
            log.warn((Object)("Error in beforeRegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
        ClassLoaderPolicy policy = classLoader.getPolicy();
        policy.setClassLoaderDomain(this);
        List<ClassLoaderInformation> list = this.classLoaders;
        synchronized (list) {
            ClassLoaderInformation info = new ClassLoaderInformation(classLoader, policy, this.order++);
            this.classLoaders.add(info);
            this.infos.put(classLoader, info);
            String[] packageNames = ((BaseClassLoaderPolicy)policy).getPackageNames();
            if (packageNames != null && info.getExported() != null) {
                for (String packageName : packageNames) {
                    List<ClassLoaderInformation> list2 = this.classLoadersByPackageName.get(packageName);
                    if (list2 == null) {
                        list2 = new CopyOnWriteArrayList<ClassLoaderInformation>();
                        this.classLoadersByPackageName.put(packageName, list2);
                    }
                    list2.add(info);
                    log.trace((Object)("Registered " + policy + " as providing package=" + packageName));
                }
            }
            this.flushCaches();
        }
        try {
            this.afterRegisterClassLoader(classLoader, classLoader.getPolicy());
        }
        catch (Throwable t) {
            log.warn((Object)("Error in afterRegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void unregisterClassLoader(BaseClassLoader classLoader) {
        log.debug((Object)(this + " unregisterClassLoader " + classLoader.toLongString()));
        try {
            this.beforeUnregisterClassLoader(classLoader, classLoader.getPolicy());
        }
        catch (Throwable t) {
            log.warn((Object)("Error in beforeUnegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
        ClassLoaderPolicy policy = classLoader.getPolicy();
        policy.unsetClassLoaderDomain(this);
        List<ClassLoaderInformation> list = this.classLoaders;
        synchronized (list) {
            ClassLoaderInformation info = this.infos.remove(classLoader);
            this.classLoaders.remove(info);
            String[] packageNames = ((BaseClassLoaderPolicy)policy).getPackageNames();
            if (packageNames != null && info.getExported() != null) {
                for (String packageName : packageNames) {
                    List<ClassLoaderInformation> list2 = this.classLoadersByPackageName.get(packageName);
                    if (list2 == null) continue;
                    list2.remove(info);
                    log.trace((Object)("Unregistered " + policy + " as providing package=" + packageName));
                    if (!list2.isEmpty()) continue;
                    this.classLoadersByPackageName.remove(packageName);
                }
            }
            this.flushCaches();
        }
        try {
            this.afterUnregisterClassLoader(classLoader, classLoader.getPolicy());
        }
        catch (Throwable t) {
            log.warn((Object)("Error in afterUnegisterClassLoader: " + this + " classLoader=" + classLoader.toLongString()), t);
        }
    }

    protected void clearBlackList(String name) {
        if (this.globalClassBlackList != null) {
            this.globalClassBlackList.remove(name);
        }
        if (this.globalResourceBlackList != null) {
            this.globalResourceBlackList.remove(name);
        }
    }
}

