/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.List;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClassLoaderPolicy {
    private static final Logger log = Logger.getLogger(BaseClassLoaderPolicy.class);
    private volatile BaseClassLoader classLoader;
    private volatile BaseClassLoaderDomain domain;
    private AccessControlContext access;

    public BaseClassLoaderPolicy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.access = AccessController.getContext();
    }

    protected AccessControlContext getAccessControlContext() {
        return this.access;
    }

    protected abstract DelegateLoader getExported();

    public abstract String[] getPackageNames();

    protected abstract List<? extends DelegateLoader> getDelegates();

    protected abstract boolean isImportAll();

    protected abstract ProtectionDomain getProtectionDomain(String var1, String var2);

    protected byte[] transform(String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        BaseClassLoaderDomain domain = this.getClassLoaderDomain();
        if (domain != null) {
            return domain.transform(this.getClassLoader(), className, byteCode, protectionDomain);
        }
        return byteCode;
    }

    protected abstract boolean isCachable();

    protected abstract boolean isBlackListable();

    protected abstract ClassLoader isJDKRequest(String var1);

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{domain=");
        if (this.domain == null) {
            builder.append("null");
        } else {
            builder.append(this.domain.toLongString());
        }
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void toLongString(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    public String getDomainName() {
        if (this.domain == null) {
            return null;
        }
        return ((ClassLoaderDomain)this.domain).getName();
    }

    BaseClassLoaderDomain getClassLoaderDomain() {
        return this.domain;
    }

    void setClassLoaderDomain(BaseClassLoaderDomain domain) {
        if (this.domain != null) {
            throw new IllegalStateException("Policy already has a domain " + this);
        }
        this.domain = domain;
    }

    void unsetClassLoaderDomain(BaseClassLoaderDomain domain) {
        if (this.domain != domain) {
            throw new IllegalStateException("Policy is not a part of the domain " + this + " domain=" + domain);
        }
        this.shutdownPolicy();
        this.domain = null;
    }

    synchronized BaseClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new IllegalStateException("No classloader associated with policy therefore it is no longer registered " + this.toLongString());
        }
        return this.classLoader;
    }

    synchronized void setClassLoader(BaseClassLoader classLoader) {
        if (this.classLoader != null) {
            throw new IllegalStateException("Policy already has a classloader previous=" + classLoader);
        }
        this.classLoader = classLoader;
    }

    protected synchronized void shutdownPolicy() {
        log.debug((Object)(this.toLongString() + " shutdown!"));
        BaseClassLoader classLoader = this.classLoader;
        this.classLoader = null;
        classLoader.shutdownClassLoader();
    }

    protected void clearBlackList(String name) {
        if (this.domain != null) {
            this.domain.clearBlackList(name);
        }
    }
}

