/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDelegateLoader
implements Loader {
    private static final Logger log = Logger.getLogger(BaseDelegateLoader.class);
    private BaseClassLoaderPolicy delegate;

    public BaseDelegateLoader(BaseClassLoaderPolicy delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    BaseClassLoaderPolicy getPolicy() {
        return this.delegate;
    }

    @Override
    public Class<?> loadClass(String className) {
        BaseClassLoader classLoader;
        try {
            classLoader = this.delegate.getClassLoader();
        }
        catch (IllegalStateException e) {
            log.warn((Object)("Not loading from policy that has no classLoader: " + this.toLongString()));
            return null;
        }
        return classLoader.loadClassLocally(className);
    }

    @Override
    public URL getResource(String name) {
        BaseClassLoader classLoader;
        try {
            classLoader = this.delegate.getClassLoader();
        }
        catch (IllegalStateException e) {
            log.warn((Object)("Not loading from policy that has no classLoader: " + this.toLongString()));
            return null;
        }
        return classLoader.getResourceLocally(name);
    }

    @Override
    public void getResources(String name, Set<URL> urls) throws IOException {
        BaseClassLoader classLoader;
        try {
            classLoader = this.delegate.getClassLoader();
        }
        catch (IllegalStateException e) {
            log.warn((Object)("Not loading from policy that has no classLoader: " + this.toLongString()));
            return;
        }
        classLoader.getResourcesLocally(name, urls);
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{delegate=").append(this.delegate.toLongString());
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void toLongString(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{delegate=").append(this.delegate);
        builder.append('}');
        return builder.toString();
    }
}

