/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.WritableValueImpl;

abstract class AbstractServiceBuilder<T>
implements ServiceBuilder<T> {
    private final ServiceName serviceId;
    private final ServiceTargetImpl serviceTarget;
    private final ServiceControllerImpl<?> parent;

    AbstractServiceBuilder(ServiceName serviceId, ServiceTargetImpl serviceTarget, ServiceControllerImpl<?> parent) {
        this.serviceId = serviceId;
        this.serviceTarget = serviceTarget;
        this.parent = parent;
    }

    final ServiceTargetImpl getServiceTarget() {
        return this.serviceTarget;
    }

    final ServiceName getServiceId() {
        return this.serviceId;
    }

    final ServiceControllerImpl<?> getParent() {
        return this.parent;
    }

    abstract Service getService();

    abstract Collection<ServiceName> getServiceAliases();

    abstract Map<ServiceName, WritableValueImpl> getProvides();

    abstract Map<ServiceName, Dependency> getDependencies();

    abstract Set<StabilityMonitor> getMonitors();

    abstract Set<ServiceListener<? super T>> getServiceListeners();

    abstract Set<LifecycleListener> getLifecycleListeners();

    abstract List<ValueInjection<?>> getValueInjections();

    abstract ServiceController.Mode getInitialMode();

    abstract List<Injector<? super T>> getOutInjections();

    abstract void addServiceListenersNoCheck(Set<? extends ServiceListener<? super T>> var1);

    abstract void addLifecycleListenersNoCheck(Set<LifecycleListener> var1);

    abstract void addMonitorsNoCheck(Collection<? extends StabilityMonitor> var1);

    abstract void addDependenciesNoCheck(Iterable<ServiceName> var1);

    static final class Dependency {
        private final ServiceName name;
        private ServiceBuilder.DependencyType dependencyType;
        private List<Injector<Object>> injectorList = new ArrayList<Injector<Object>>(0);

        Dependency(ServiceName name, ServiceBuilder.DependencyType dependencyType) {
            this.name = name;
            this.dependencyType = dependencyType;
        }

        ServiceName getName() {
            return this.name;
        }

        List<Injector<Object>> getInjectorList() {
            return this.injectorList;
        }

        ServiceBuilder.DependencyType getDependencyType() {
            return this.dependencyType;
        }

        void setDependencyType(ServiceBuilder.DependencyType dependencyType) {
            this.dependencyType = dependencyType;
        }
    }
}

