/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.management;

/**
 * Impact.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public enum Impact
{
   /** Performs some action */
   ACTION(MBeanOperationInfo.ACTION),

   /** Performs some action and returns information */
   ACTION_INFO(MBeanOperationInfo.ACTION_INFO),
   
   /** Returns information */
   INFO(MBeanOperationInfo.INFO),

   /** Unspecified */
   UNKNOWN(MBeanOperationInfo.UNKNOWN);

   /** The equivalent code */
   private int code;
   
   Impact(int code)
   {
      this.code = code;
   }
   
   /**
    * Get the equivalent code for use in the MBeanOperationInfo 
    * 
    * @return the code
    */
   public int getCode()
   {
      return code;
   }

   /**
    * Get the impact for a code specified in MBeanOperationInfo
    * 
    * @param code the code
    * @return the impact
    */
   public static Impact forCode(int code)
   {
      switch (code)
      {
         case MBeanOperationInfo.ACTION: return ACTION;
         case MBeanOperationInfo.ACTION_INFO: return ACTION_INFO;
         case MBeanOperationInfo.INFO: return INFO;
         default : return UNKNOWN;
      }
   }
}
