/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.path;

public class RelativePathParser {
    private static final int STATE_BEGIN = 0;
    private static final int STATE_DOT = 1;
    private static final int STATE_DOT_DOT = 2;
    private static final int STATE_CHAR = 3;
    public static final int NONE = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    private final String path;
    private int current;
    private int previous;
    private int offset;
    private int length;

    public RelativePathParser(String path) {
        if (path == null) {
            throw new IllegalArgumentException("No path");
        }
        this.path = path;
        this.previous = 0;
        this.current = 0;
    }

    public int next() {
        this.previous = this.current;
        int state = 0;
        block23: while (this.current < this.path.length()) {
            char c = this.path.charAt(this.current++);
            switch (c) {
                case '.': {
                    switch (state) {
                        case 0: {
                            state = 1;
                            continue block23;
                        }
                        case 1: {
                            state = 2;
                            continue block23;
                        }
                        case 3: {
                            continue block23;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case '/': {
                    switch (state) {
                        default: {
                            throw new IllegalStateException("");
                        }
                        case 1: {
                            this.previous = this.current;
                            state = 0;
                            continue block23;
                        }
                        case 2: {
                            this.length = -1;
                            this.offset = -1;
                            return 1;
                        }
                        case 3: 
                    }
                    this.length = this.current - this.previous - 1;
                    this.offset = this.previous;
                    return 2;
                }
            }
            switch (state) {
                case 0: {
                    state = 3;
                    continue block23;
                }
                case 3: {
                    continue block23;
                }
            }
            throw new IllegalStateException("");
        }
        switch (state) {
            case 0: 
            case 1: {
                this.length = -1;
                this.offset = -1;
                return 0;
            }
            case 3: {
                this.offset = this.previous;
                this.length = this.current - this.previous;
                return 2;
            }
            case 2: {
                this.length = -1;
                this.offset = -1;
                return 1;
            }
        }
        throw new IllegalStateException("");
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }
}

