/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.web.impl.tomcat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Engine;
import org.apache.catalina.Wrapper;
import org.jboss.portal.web.impl.tomcat.TC6ServletContainerContext;

public class TC6ContainerServlet
extends HttpServlet
implements ContainerServlet {
    private Wrapper wrapper;
    private TC6ServletContainerContext containerContext;
    private boolean started;

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper != null) {
            this.attemptStart();
        } else {
            this.attemptStop();
        }
    }

    public void init() throws ServletException {
        this.started = true;
        this.attemptStart();
    }

    public void destroy() {
        this.started = false;
        this.attemptStop();
    }

    private void attemptStart() {
        if (this.started && this.wrapper != null) {
            this.start();
        }
    }

    private void attemptStop() {
        if (!this.started || this.wrapper == null) {
            this.stop();
        }
    }

    private void start() {
        Wrapper container = this.wrapper;
        while (container.getParent() != null) {
            if (!((container = container.getParent()) instanceof Engine)) continue;
            Engine engine = (Engine)container;
            this.containerContext = new TC6ServletContainerContext(engine);
            this.containerContext.start();
            break;
        }
    }

    private void stop() {
        if (this.containerContext != null) {
            this.containerContext.stop();
            this.containerContext = null;
        }
    }
}

