/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeException;
import org.ajax4jsf.context.AjaxContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.BridgeConfig;
import org.jboss.portletbridge.ExceptionHandler;
import org.jboss.portletbridge.ExceptionHandlerImpl;
import org.jboss.portletbridge.ExcludedRequestAttribute;
import org.jboss.portletbridge.application.PortletStateHolder;
import org.jboss.portletbridge.application.PortletViewState;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.util.FacesConfig;
import org.jboss.portletbridge.util.WebXML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxPortletBridge
implements Bridge,
ELContextListener,
BridgeConfig {
    public static final String VIEWID_HISTORY_PREFIX = "javax.portlet.faces.viewIdHistory.";
    private static final Log log = LogFactory.getLog(AjaxPortletBridge.class);
    private static final String EXCEPTION_HANDLER_CLASS_PARAMETER = ExceptionHandler.class.getName();
    private boolean initialized = false;
    private PortletConfig portletConfig;
    private ExceptionHandler exceptionHandler;
    private Lifecycle lifecycle;
    private FacesContextFactory facesContextFactory;
    private List<String> facesServletMappings;
    private Set<ExcludedRequestAttribute> excludedAttributes;
    private boolean preserveActionParams;
    private Map<String, String> defaultViewIdMap;
    private PortletStateHolder stateHolder;

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy portletbridge " + this.getPortletConfig().getPortletName()));
        }
        this.lifecycle = null;
        this.facesContextFactory = null;
        this.stateHolder = null;
        this.initialized = false;
    }

    public void init(PortletConfig config) throws BridgeException {
        if (null == config) {
            throw new NullPointerException("No PortletConfig at the bridge initialization");
        }
        if (this.initialized) {
            throw new BridgeException("JSF portlet bridge already initialized");
        }
        String portletName = config.getPortletName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start portletbridge initialization for " + portletName));
        }
        this.portletConfig = config;
        PortletContext portletContext = config.getPortletContext();
        this.stateHolder = PortletStateHolder.init(portletContext);
        this.initFaces(portletContext);
        this.exceptionHandler = this.createExceptionHandler(portletContext);
        WebXML webXml = new WebXML();
        webXml.parse(portletContext);
        this.facesServletMappings = webXml.getFacesServletMappings();
        if (null == this.facesServletMappings || this.facesServletMappings.size() == 0) {
            throw new BridgeException("Unable to get Faces Servlet mapping");
        }
        this.excludedAttributes = new HashSet<ExcludedRequestAttribute>();
        String bridgeParametersPrefix = "javax.portlet.faces." + portletName + ".";
        List<String> excluded = (List<String>)portletContext.getAttribute(bridgeParametersPrefix + "excludedRequestAttributes");
        if (null != excluded) {
            for (String name : excluded) {
                this.excludedAttributes.add(new ExcludedRequestAttribute(name));
            }
        }
        FacesConfig facesConfig = new FacesConfig();
        facesConfig.parse(portletContext);
        excluded = facesConfig.getExcludedAttributes();
        if (null != excluded) {
            for (String name : excluded) {
                this.excludedAttributes.add(new ExcludedRequestAttribute(name));
            }
        }
        Boolean preserveParams = (Boolean)portletContext.getAttribute(bridgeParametersPrefix + "preserveActionParams");
        this.preserveActionParams = Boolean.TRUE.equals(preserveParams);
        this.defaultViewIdMap = (Map)portletContext.getAttribute(bridgeParametersPrefix + "defaultViewIdMap");
        if (null == this.defaultViewIdMap || 0 == this.defaultViewIdMap.size()) {
            throw new BridgeException("No JSF view id's defined in portlet");
        }
        this.initialized = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Done portletbridge initialisation for " + portletName));
        }
    }

    protected void initFaces(PortletContext portletContext) {
        try {
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
            if (null == lifecycleId) {
                lifecycleId = "DEFAULT";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create instance of a JSF lifecycle " + lifecycleId));
            }
            this.lifecycle = factory.getLifecycle(lifecycleId);
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.lifecycle.getPhaseListeners();
            ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            Application app = appFactory.getApplication();
            app.addELContextListener((ELContextListener)this);
        }
        catch (FacesException e) {
            throw new BridgeException("JSF Initialization error", (Throwable)e);
        }
    }

    protected ExceptionHandler createExceptionHandler(PortletContext portletContext) {
        String exceptionHandlerClassName = portletContext.getInitParameter(EXCEPTION_HANDLER_CLASS_PARAMETER);
        ExceptionHandler handler = null;
        if (null != exceptionHandlerClassName) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == classLoader) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                Class<ExceptionHandler> exceptionHandlerClass = classLoader.loadClass(exceptionHandlerClassName).asSubclass(ExceptionHandler.class);
                handler = exceptionHandlerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                handler = new ExceptionHandlerImpl();
            }
            catch (InstantiationException e) {
                handler = new ExceptionHandlerImpl();
            }
            catch (IllegalAccessException e) {
                handler = new ExceptionHandlerImpl();
            }
        } else {
            handler = new ExceptionHandlerImpl();
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(ActionRequest request, ActionResponse response) throws BridgeException {
        if (null == request) {
            throw new NullPointerException("Request parameter is null");
        }
        if (null == response) {
            throw new NullPointerException("Response parameter is null");
        }
        if (!this.isInitialized()) {
            throw new BridgeException("JSF Portlet bridge is not initialized");
        }
        this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.ActionPhase);
        String stateId = this.getStateHolder().getStateId(this.getPortletName(), request);
        PortletViewState windowState = new PortletViewState(){

            public BridgeConfig getBridgeConfig() {
                return AjaxPortletBridge.this;
            }
        };
        this.getStateHolder().addWindowState(stateId, windowState);
        response.setRenderParameter("javax.faces.portletbridge.STATE_ID", stateId);
        PortletBridgeContext bridgeContext = this.createBridgeContext((PortletRequest)request, windowState);
        FacesContext facesContext = this.getFacesContext(request, response);
        try {
            this.execute(facesContext);
            if (!facesContext.getResponseComplete()) {
                facesContext.getApplication().getStateManager().saveView(facesContext);
                windowState.saveRequest(facesContext);
            } else {
                windowState.reset();
                String redirectViewId = bridgeContext.getRedirectViewId();
                if (null != redirectViewId) {
                    windowState.setViewId(redirectViewId);
                }
                windowState.setRequestParameters(bridgeContext.getRedirectRequestParameters());
            }
            facesContext.getExternalContext().getSessionMap().put(VIEWID_HISTORY_PREFIX + request.getPortletMode().toString(), windowState.getViewId());
        }
        catch (Exception e) {
            log.error((Object)"Error processing execute lifecycle", (Throwable)e);
            this.exceptionHandler.processActionException(facesContext, windowState, e);
        }
        finally {
            facesContext.release();
        }
    }

    private PortletBridgeContext createBridgeContext(PortletRequest request, PortletViewState windowState) {
        PortletBridgeContext bridgeContext = windowState.createBridgeContext();
        request.setAttribute(PortletBridgeContext.REQUEST_PARAMETER_NAME, (Object)bridgeContext);
        bridgeContext.setInitialRequestAttributeNames(new HashSet<String>(Collections.list(request.getAttributeNames())));
        return bridgeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(RenderRequest request, RenderResponse response) throws BridgeException {
        if (null == request) {
            throw new NullPointerException("Request parameter is null");
        }
        if (null == response) {
            throw new NullPointerException("Response parameter is null");
        }
        if (!this.isInitialized()) {
            throw new BridgeException("JSF Portlet bridge is not initialized");
        }
        this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.RenderPhase);
        String namespace = response.getNamespace();
        String stateId = this.getStateHolder().getStateId(this.getPortletName(), namespace, request);
        PortletViewState windowState = this.getStateHolder().getWindowState(stateId);
        if (null == windowState) {
            windowState = new PortletViewState(){

                public BridgeConfig getBridgeConfig() {
                    return AjaxPortletBridge.this;
                }
            };
            this.getStateHolder().addWindowState(stateId, windowState);
        }
        PortletBridgeContext bridgeContext = this.createBridgeContext((PortletRequest)request, windowState);
        FacesContext facesContext = this.getFacesContext(request, response);
        windowState.restoreRequest(facesContext, true);
        try {
            ResourceBundle bundle = this.portletConfig.getResourceBundle(request.getLocale());
            if (bundle != null) {
                String title = null;
                try {
                    title = bundle.getString("javax.portlet.title");
                    response.setTitle(title);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
            Map commonAjaxParameters = ajaxContext.getCommonAjaxParameters();
            commonAjaxParameters.put("javax.faces.portletbridge.STATE_ID", stateId);
            this.renderResponse(facesContext, windowState);
            String redirectViewId = bridgeContext.getRedirectViewId();
            if (null != redirectViewId) {
                windowState.reset();
                windowState.setViewId(redirectViewId);
                Map<String, String[]> redirectParams = bridgeContext.getRedirectRequestParameters();
                facesContext.release();
                Set<String> initialAttributes = bridgeContext.getInitialRequestAttributeNames();
                ArrayList currentAttributes = Collections.list(request.getAttributeNames());
                currentAttributes.removeAll(initialAttributes);
                for (Object newAttribute : currentAttributes) {
                    request.removeAttribute((String)newAttribute);
                }
                if (redirectParams != null) {
                    windowState.setRequestParameters(redirectParams);
                }
                facesContext = this.getFacesContext(request, response);
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                UIViewRoot viewRoot = viewHandler.createView(facesContext, redirectViewId);
                facesContext.setViewRoot(viewRoot);
                this.renderResponse(facesContext, windowState);
            }
            String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
            actionURL = facesContext.getExternalContext().encodeActionURL(actionURL);
            windowState.setPortalActionURL(new PortalActionURL(actionURL));
            PortletURL portletURL = response.createRenderURL();
            portletURL.setParameter("javax.faces.portletbridge.STATE_ID", stateId);
            String renderUrl = portletURL.toString();
            windowState.setPortalRenderURL(new PortalActionURL(renderUrl));
            windowState.setNamespace(namespace);
            facesContext.getExternalContext().getSessionMap().put(VIEWID_HISTORY_PREFIX + request.getPortletMode().toString(), windowState.getViewId());
            PortletSession portletSession = (PortletSession)facesContext.getExternalContext().getSession(true);
            PortletStateHolder.WindowIDRetriver idRetriver = (PortletStateHolder.WindowIDRetriver)portletSession.getAttribute("org.jboss.portletbridge.WINDOW_ID_RETRIVER");
            if (null != idRetriver) {
                windowState.setWindowId(idRetriver.getWindowID());
            }
            Principal userPrincipal = facesContext.getExternalContext().getUserPrincipal();
            portletSession.setAttribute("org.jboss.portletbridge.USER_PRINCIPAL", (Object)userPrincipal, 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finish rendering portletbridge for namespace " + namespace));
            }
            response.setProperty("portlet.expiration-cache", "0");
        }
        catch (Exception e) {
            response.reset();
            log.error((Object)"Error processing execute lifecycle", (Throwable)e);
            this.exceptionHandler.processRenderException(facesContext, windowState, e);
        }
        finally {
            facesContext.release();
        }
    }

    private void renderResponse(FacesContext facesContext, PortletViewState windowState) throws FacesException {
        if (null == facesContext.getViewRoot()) {
            this.execute(facesContext);
        }
        if (!facesContext.getResponseComplete()) {
            this.render(facesContext);
        }
    }

    protected void initRequest(PortletRequest request, PortletResponse response, Bridge.PortletPhase actionPhase) throws BridgeException {
        request.setAttribute("javax.portlet.faces.phase", (Object)actionPhase);
        Map<String, String> viewIdMap = this.getDefaultViewIdMap();
        String firstMode = viewIdMap.keySet().iterator().next();
        PortletSession portletSession = request.getPortletSession();
        if (null == portletSession.getAttribute(VIEWID_HISTORY_PREFIX + firstMode)) {
            for (Map.Entry<String, String> entry : viewIdMap.entrySet()) {
                portletSession.setAttribute(VIEWID_HISTORY_PREFIX + entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    @Override
    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    protected Object getContext() {
        return this.portletConfig.getPortletContext();
    }

    @Override
    public String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (null == initParameter) {
            initParameter = this.portletConfig.getPortletContext().getInitParameter(name);
        }
        return initParameter;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public List<String> getFacesServletMappings() {
        return this.facesServletMappings;
    }

    @Override
    public Set<ExcludedRequestAttribute> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    @Override
    public String getPortletName() {
        return this.portletConfig.getPortletName();
    }

    @Override
    public boolean isPreserveActionParams() {
        return this.preserveActionParams;
    }

    @Override
    public Map<String, String> getDefaultViewIdMap() {
        return this.defaultViewIdMap;
    }

    protected PortletStateHolder getStateHolder() {
        return this.stateHolder;
    }

    public void contextCreated(ELContextEvent event) {
        ELContext elContext = event.getELContext();
        if (elContext.getContext(PortletConfig.class) == null) {
            elContext.putContext(PortletConfig.class, (Object)this.portletConfig);
        }
    }

    protected Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    protected FacesContext getFacesContext(Object request, Object response) {
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getContext(), request, response, this.getLifecycle());
        return facesContext;
    }

    protected void execute(FacesContext context) throws FacesException {
        this.getLifecycle().execute(context);
    }

    protected void render(FacesContext context) throws FacesException {
        this.getLifecycle().render(context);
    }
}

