/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeUninitializedException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.application.PortletStateHolder;
import org.jboss.portletbridge.context.AbstractExternalContext;
import org.jboss.portletbridge.context.EnumerationIterator;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.context.ServletSessionWrapper;
import org.jboss.portletbridge.context.SessionAttributesNames;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletExternalContextImpl
extends AbstractExternalContext {
    private static final Log _log = LogFactory.getLog(ServletExternalContextImpl.class);
    private String namespace = "";
    private String sessionPrefix = "";
    private PortalActionURL portalActionUrl;

    public ServletExternalContextImpl(ServletContext context, HttpServletRequest request, HttpServletResponse response, String stateId) {
        super(context, request, response);
        PortletStateHolder portletStateHolder = (PortletStateHolder)context.getAttribute(PortletStateHolder.STATE_HOLDER);
        if (null != portletStateHolder) {
            this.windowState = portletStateHolder.getWindowState(stateId);
            if (null == this.windowState) {
                throw new FacesException("No saved portlet window state for an id " + stateId);
            }
        } else {
            throw new BridgeUninitializedException("JSF Portlet bridge was not initialised before AJAX request");
        }
        this.namespace = this.windowState.getNamespace();
        String windowId = this.windowState.getWindowId();
        this.sessionPrefix = "javax.portlet.p." + windowId + '?';
        this.portalActionUrl = this.windowState.getPortalActionURL();
        this.portletBridgeContext = this.windowState.createBridgeContext();
        this.portletBridgeContext.setInitialRequestAttributeNames(new HashSet<String>(Collections.list(request.getAttributeNames())));
        request.setAttribute(PortletBridgeContext.REQUEST_PARAMETER_NAME, (Object)this.portletBridgeContext);
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.getHttpResponse().setCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.getHttpResponse().getCharacterEncoding();
    }

    public String getResponseContentType() {
        return this.getHttpResponse().getContentType();
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.getHttpRequest().setCharacterEncoding(encoding);
    }

    public String getRequestCharacterEncoding() {
        return this.getHttpRequest().getCharacterEncoding();
    }

    public String getRequestContentType() {
        return this.getHttpRequest().getContentType();
    }

    private HttpServletRequest getHttpRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    private ServletContext getServletContext() {
        return (ServletContext)this.getContext();
    }

    private HttpServletResponse getHttpResponse() {
        return (HttpServletResponse)this.getResponse();
    }

    @Override
    protected String getNamespace() {
        return this.namespace;
    }

    public String getInitParameter(String name) {
        return this.getServletContext().getInitParameter(name);
    }

    @Override
    protected Enumeration<String> getInitParametersNames() {
        return this.getServletContext().getInitParameterNames();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getServletContext().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getServletContext().getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.getServletContext().getResourcePaths(path);
    }

    @Override
    protected Object getContextAttribute(String name) {
        return this.getServletContext().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getContextAttributeNames() {
        return this.getServletContext().getAttributeNames();
    }

    @Override
    protected void setContextAttribute(String name, Object value) {
        this.getServletContext().setAttribute(name, value);
    }

    public String getAuthType() {
        return this.getHttpRequest().getAuthType();
    }

    public String getRemoteUser() {
        Principal userPrincipal = this.getUserPrincipal();
        if (null != userPrincipal) {
            return userPrincipal.getName();
        }
        return this.getHttpRequest().getRemoteUser();
    }

    public String getRequestContextPath() {
        return this.getHttpRequest().getContextPath();
    }

    public String getRequestPathInfo() {
        return this.getHttpRequest().getPathInfo();
    }

    public String getRequestServletPath() {
        return this.getHttpRequest().getServletPath();
    }

    @Override
    protected Enumeration<String> enumerateRequestParameterNames() {
        return this.getHttpRequest().getParameterNames();
    }

    @Override
    protected Object getRequestAttribute(String name) {
        return this.getHttpRequest().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getRequestAttributeNames() {
        return this.getHttpRequest().getAttributeNames();
    }

    @Override
    protected String[] getRequestParameterValues(String name) {
        return this.getHttpRequest().getParameterValues(name);
    }

    @Override
    protected String getRequestHeader(String name) {
        return this.getHttpRequest().getHeader(name);
    }

    @Override
    protected Enumeration<String> getRequestHeaderNames() {
        return this.getHttpRequest().getHeaderNames();
    }

    @Override
    protected String[] getRequestHeaderValues(String name) {
        Enumeration values = this.getHttpRequest().getHeaders(name);
        ArrayList valuesList = new ArrayList();
        while (values.hasMoreElements()) {
            valuesList.add(values.nextElement());
        }
        return valuesList.toArray(EMPTY_STRING_ARRAY);
    }

    @Override
    protected String getRequestParameter(String name) {
        return this.getHttpRequest().getParameter(name);
    }

    private String getSessionPrefix() {
        return this.sessionPrefix;
    }

    @Override
    protected Object getSessionAttribute(String name) {
        return this.getHttpRequest().getSession(true).getAttribute(this.getSessionPrefix() + name);
    }

    @Override
    protected Enumeration<String> getSessionAttributeNames() {
        return new SessionAttributesNames(this.getHttpRequest().getSession(true).getAttributeNames(), this.getSessionPrefix());
    }

    @Override
    protected void removeSessionAttribute(String name) {
        this.getHttpRequest().getSession(true).removeAttribute(this.getSessionPrefix() + name);
    }

    @Override
    protected void setSessionAttribute(String name, Object value) {
        this.getHttpRequest().getSession(true).setAttribute(this.getSessionPrefix() + name, value);
    }

    @Override
    protected void removeContextAttribute(String name) {
        this.getHttpRequest().getSession(true).removeAttribute(name);
    }

    @Override
    protected void removeRequestAttribute(String name) {
        this.getHttpRequest().removeAttribute(name);
    }

    @Override
    protected void setRequestAttribute(String name, Object value) {
        this.getHttpRequest().setAttribute(name, value);
    }

    public void dispatch(String path) throws IOException {
        RequestDispatcher requestDispatcher = this.getHttpRequest().getRequestDispatcher(path);
        if (requestDispatcher == null) {
            this.getHttpResponse().sendError(404);
            return;
        }
        try {
            requestDispatcher.forward((ServletRequest)this.getHttpRequest(), (ServletResponse)this.getHttpResponse());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException se) {
            throw new FacesException((Throwable)se);
        }
    }

    @Override
    protected String createActionUrl(PortalActionURL url) {
        PortalActionURL actionUrl = new PortalActionURL(this.portalActionUrl);
        actionUrl.getParameters().putAll(url.getParameters());
        actionUrl.addParameter("org.jboss.portletbridge.VIEWID", this.getViewIdFromUrl(url));
        return actionUrl.toString();
    }

    protected String getViewIdFromUrl(PortalActionURL url) {
        String viewId = url.getParameter("org.jboss.portletbridge.VIEWID");
        if (null == viewId) {
            viewId = url.getPath();
            if (viewId.startsWith(this.getRequestContextPath())) {
                viewId = viewId.substring(this.getRequestContextPath().length());
            }
            if (null != this.getRequestServletPath() && null != this.getRequestPathInfo()) {
                if (viewId.startsWith(this.getRequestServletPath())) {
                    viewId = viewId.substring(this.getRequestServletPath().length());
                }
            } else if (null != this.getRequestPathInfo()) {
                int i = viewId.lastIndexOf(46);
                int j = this.getRequestPathInfo().lastIndexOf(46);
                if (i >= 0 && j >= 0) {
                    viewId = viewId.substring(0, i) + this.getRequestPathInfo().substring(j);
                }
            }
        }
        return viewId;
    }

    @Override
    protected String encodeURL(String url) {
        return this.getHttpResponse().encodeURL(url);
    }

    public Locale getRequestLocale() {
        return this.getHttpRequest().getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        return new EnumerationIterator<Locale>(this.getHttpRequest().getLocales());
    }

    public Object getSession(boolean create) {
        HttpSession session = this.getHttpRequest().getSession(create);
        if (null != session) {
            session = new ServletSessionWrapper(session, this.getSessionPrefix());
        }
        return session;
    }

    public Principal getUserPrincipal() {
        Principal portalPrincipal;
        Principal userPrincipal = this.getHttpRequest().getUserPrincipal();
        HttpSession httpSession = this.getHttpRequest().getSession(false);
        if (null != httpSession && null != (portalPrincipal = (Principal)httpSession.getAttribute("org.jboss.portletbridge.USER_PRINCIPAL"))) {
            userPrincipal = portalPrincipal;
        }
        return userPrincipal;
    }

    public boolean isUserInRole(String role) {
        return this.getHttpRequest().isUserInRole(role);
    }

    public void log(String message) {
        this.getServletContext().log(message);
    }

    public void log(String message, Throwable exception) {
        this.getServletContext().log(message, exception);
    }

    public void redirect(String url) throws IOException {
        this.getHttpResponse().sendRedirect(url);
        FacesContext.getCurrentInstance().responseComplete();
    }
}

