/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.faces.Bridge;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.application.PortletViewState;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.jsf.SeamPhaseListener;

public class SeamPhaseListenerWrapper
implements PhaseListener {
    private final SeamPhaseListener _defaultListener;
    private static final Log log = LogFactory.getLog(SeamPhaseListenerWrapper.class);
    private static final long serialVersionUID = -8465467659533393697L;

    public SeamPhaseListenerWrapper(PhaseListener defaultListener) {
        this._defaultListener = (SeamPhaseListener)defaultListener;
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        Bridge.PortletPhase portletPhase = (Bridge.PortletPhase)externalContext.getRequestMap().get("javax.portlet.faces.phase");
        if (null != portletPhase) {
            try {
                this._defaultListener.raiseEventsAfterPhase(event);
                this.afterPortletPhase(event, facesContext, portletPhase);
            }
            catch (Exception e) {
                log.debug((Object)"uncaught exception, try to recovery", (Throwable)e);
                try {
                    Exceptions.instance().handle(e);
                    if (facesContext.getResponseComplete()) {
                        this._defaultListener.afterResponseComplete(facesContext);
                    }
                }
                catch (Exception ehe) {
                    log.error((Object)"swallowing exception", (Throwable)e);
                }
            }
            FacesLifecycle.clearPhaseId();
        } else {
            this._defaultListener.afterPhase(event);
        }
    }

    private void afterPortletPhase(PhaseEvent event, FacesContext facesContext, Bridge.PortletPhase portletPhase) {
        PhaseId phaseId = event.getPhaseId();
        if (phaseId == PhaseId.RESTORE_VIEW) {
            this._defaultListener.afterRestoreView(facesContext);
        } else if (phaseId == PhaseId.INVOKE_APPLICATION) {
            this._defaultListener.afterInvokeApplication();
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            this._defaultListener.afterProcessValidations(facesContext);
        }
        FacesMessages.afterPhase();
        this._defaultListener.handleTransactionsAfterPhase(event);
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this._defaultListener.afterRenderResponse(facesContext);
        } else if (Bridge.PortletPhase.ActionPhase.equals((Object)portletPhase) && (phaseId == PhaseId.INVOKE_APPLICATION || facesContext.getRenderResponse() || facesContext.getResponseComplete())) {
            Manager manager = Manager.instance();
            manager.beforeRedirect();
            PortletBridgeContext bridgeContext = (PortletBridgeContext)facesContext.getExternalContext().getRequestMap().get(PortletBridgeContext.REQUEST_PARAMETER_NAME);
            if (null != bridgeContext) {
                PortletViewState windowState = bridgeContext.getViewState();
                windowState.saveSeamConversationId(facesContext);
            }
            this._defaultListener.afterResponseComplete(facesContext);
        }
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        Bridge.PortletPhase portletPhase = (Bridge.PortletPhase)externalContext.getRequestMap().get("javax.portlet.faces.phase");
        if (null != portletPhase) {
            log.trace((Object)("before phase: " + event.getPhaseId()));
            FacesLifecycle.setPhaseId((PhaseId)event.getPhaseId());
            try {
                this.beforePortletPhase(event, facesContext, portletPhase);
                this._defaultListener.raiseEventsBeforePhase(event);
            }
            catch (Exception e) {
                log.debug((Object)"uncaught exception, try to recovery", (Throwable)e);
                try {
                    Exceptions.instance().handle(e);
                }
                catch (Exception ehe) {
                    log.error((Object)"swallowing exception", (Throwable)e);
                }
            }
        } else {
            this._defaultListener.beforePhase(event);
        }
    }

    private void beforePortletPhase(PhaseEvent event, FacesContext facesContext, Bridge.PortletPhase portletPhase) {
        boolean notInitialised = false;
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this._defaultListener.beforeRestoreView(facesContext);
        }
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && !Contexts.isApplicationContextActive()) {
            this._defaultListener.beforeRestoreView(facesContext);
            this._defaultListener.afterRestoreView(facesContext);
            notInitialised = true;
        }
        this._defaultListener.handleTransactionsBeforePhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            if (notInitialised) {
                // empty if block
            }
            this._defaultListener.beforeRenderResponse(facesContext);
        }
    }

    public PhaseId getPhaseId() {
        return this._defaultListener.getPhaseId();
    }
}

