/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.management.deploy;


/**
 * A target to which a deployment is uploaded.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 92346 $
 */
public interface DeploymentTarget
{
   /**
    * Get the target name
    *
    * @return the name
    */
   String getName();

   
   String[] getRepositoryNames(DeploymentID deployment)
      throws Exception;

   void distribute(DeploymentID deployment)
      throws Exception;
   void redeploy(DeploymentID deployment)
      throws Exception;
   void prepare(DeploymentID deployment)
      throws Exception;
   void start(DeploymentID deployment)
      throws Exception;
   void stop(DeploymentID deployment)
      throws Exception;
   void remove(DeploymentID deployment)
      throws Exception;

   /**
    * Get the target description
    *
    * @return the description
    */
   String getDescription();

}
