/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.deployment;

import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;

/**
 * The profile deployment info.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileDeploymentInfo
{

   /**
    * Get the deployment name
    * 
    * @return the deployment name
    */
   String getName();
   
   /**
    * Get the virtual deployment meta data.
    * 
    * @return the virtual deployment meta data.
    */
   VirtualDeploymentMetaData getMetaData();
   
   /**
    * Flag indicating if a deployment is deployed.
    * 
    * @return true if deployed, false otherwise
    */
   boolean isDeployed();

   /**
    * Flag indicating if the deployment is locked for
    * modification checking.
    * 
    * @return true if locked, false otherwise
    */
   boolean isLocked();
   
   /**
    * Check whether the deployment has the indicated flag.
    * 
    * @param flag the flag
    * @return true if the policy contains the flag, false otherwise.
    */
   boolean hasFlag(ProfileDeploymentFlag flag);

   /**
    * Set a deployment flag.
    * 
    * @param flag the flag
    */
   void setFlag(ProfileDeploymentFlag flag);

   /**
    * Clear the deployment flag.
    * 
    * @param flag the flag
    */
   void clearFlag(ProfileDeploymentFlag flag);
}

