/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.jxl;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import jxl.CellFeatures;
import jxl.CellView;
import jxl.HeaderFooter;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.Validation;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.excel.ui.UIBackground;
import org.jboss.seam.excel.ui.UIBorder;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UICellFormat;
import org.jboss.seam.excel.ui.UIColumn;
import org.jboss.seam.excel.ui.UIFont;
import org.jboss.seam.excel.ui.UIHeaderFooter;
import org.jboss.seam.excel.ui.UIHeaderFooterCommand;
import org.jboss.seam.excel.ui.UIListValidation;
import org.jboss.seam.excel.ui.UIListValidationItem;
import org.jboss.seam.excel.ui.UINumericValidation;
import org.jboss.seam.excel.ui.UIPrintArea;
import org.jboss.seam.excel.ui.UIPrintTitles;
import org.jboss.seam.excel.ui.UIRangeValidation;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.UIWorksheetSettings;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class JXLExcelFactory {
    private static Log log = Logging.getLog(JXLExcelFactory.class);
    private static final String JXL_VERTICAL_ALIGNMENT_CLASS_NAME = "jxl.format.VerticalAlignment";
    private static final String JXL_ORIENTATION_CLASS_NAME = "jxl.format.Orientation";
    private static final String JXL_ALIGNMENT_CLASS_NAME = "jxl.format.Alignment";
    private static final String JXL_PATTERN_CLASS_NAME = "jxl.format.Pattern";
    private static final String JXL_BORDER_LINE_STYLE_CLASS_NAME = "jxl.format.BorderLineStyle";
    private static final String JXL_BORDER_CLASS_NAME = "jxl.format.Border";
    private static final String JXL_UNDERLINE_STYLE_CLASS_NAME = "jxl.format.UnderlineStyle";
    private static final String JXL_SCRIPT_STYLE_CLASS_NAME = "jxl.format.ScriptStyle";
    private static final String JXL_COLOR_CLASS_NAME = "jxl.format.Colour";
    private static final String JXL_PAGE_ORIENTATION_CLASS_NAME = "jxl.format.PageOrientation";
    private static final String JXL_PAPER_SIZE_CLASS_NAME = "jxl.format.PaperSize";
    private static final String HEADER_FOOTER_COMMAND_CLASS_NAME = "org.jboss.seam.excel.UIHeaderFooterCommand";

    public static WorkbookSettings createWorkbookSettings(UIWorkbook uiWorkbook) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating workbook settings from #0", new Object[]{uiWorkbook});
        }
        WorkbookSettings workbookSettings = new WorkbookSettings();
        if (uiWorkbook.getArrayGrowSize() != null) {
            workbookSettings.setArrayGrowSize(uiWorkbook.getArrayGrowSize().intValue());
        }
        if (uiWorkbook.getAutoFilterDisabled() != null) {
            workbookSettings.setAutoFilterDisabled(uiWorkbook.getAutoFilterDisabled().booleanValue());
        }
        if (uiWorkbook.getAutoFilterDisabled() != null) {
            workbookSettings.setCellValidationDisabled(uiWorkbook.getAutoFilterDisabled().booleanValue());
        }
        if (uiWorkbook.getCharacterSet() != null) {
            workbookSettings.setCharacterSet(uiWorkbook.getCharacterSet().intValue());
        }
        if (uiWorkbook.getDrawingsDisabled() != null) {
            workbookSettings.setDrawingsDisabled(uiWorkbook.getDrawingsDisabled().booleanValue());
        }
        if (uiWorkbook.getEncoding() != null) {
            workbookSettings.setEncoding(uiWorkbook.getEncoding());
        }
        if (uiWorkbook.getExcelDisplayLanguage() != null) {
            workbookSettings.setExcelDisplayLanguage(uiWorkbook.getExcelDisplayLanguage());
        }
        if (uiWorkbook.getExcelRegionalSettings() != null) {
            workbookSettings.setExcelRegionalSettings(uiWorkbook.getExcelRegionalSettings());
        }
        if (uiWorkbook.getFormulaAdjust() != null) {
            workbookSettings.setFormulaAdjust(uiWorkbook.getFormulaAdjust().booleanValue());
        }
        if (uiWorkbook.getGcDisabled() != null) {
            workbookSettings.setGCDisabled(uiWorkbook.getGcDisabled().booleanValue());
        }
        if (uiWorkbook.getIgnoreBlanks() != null) {
            workbookSettings.setIgnoreBlanks(uiWorkbook.getIgnoreBlanks().booleanValue());
        }
        if (uiWorkbook.getLocale() != null) {
            workbookSettings.setLocale(new Locale(uiWorkbook.getLocale()));
        }
        if (uiWorkbook.getMergedCellCheckingDisabled() != null) {
            workbookSettings.setMergedCellChecking(uiWorkbook.getMergedCellCheckingDisabled().booleanValue());
        }
        if (uiWorkbook.getNamesDisabled() != null) {
            workbookSettings.setNamesDisabled(uiWorkbook.getNamesDisabled().booleanValue());
        }
        if (uiWorkbook.getPropertySets() != null) {
            workbookSettings.setPropertySets(uiWorkbook.getPropertySets().booleanValue());
        }
        if (uiWorkbook.getRationalization() != null) {
            workbookSettings.setRationalization(uiWorkbook.getRationalization().booleanValue());
        }
        if (uiWorkbook.getSupressWarnings() != null) {
            workbookSettings.setSuppressWarnings(uiWorkbook.getSupressWarnings().booleanValue());
        }
        if (uiWorkbook.getTemporaryFileDuringWriteDirectory() != null) {
            workbookSettings.setTemporaryFileDuringWriteDirectory(new File(uiWorkbook.getTemporaryFileDuringWriteDirectory()));
        }
        if (uiWorkbook.getUseTemporaryFileDuringWrite() != null) {
            workbookSettings.setUseTemporaryFileDuringWrite(uiWorkbook.getUseTemporaryFileDuringWrite().booleanValue());
        }
        return workbookSettings;
    }

    private static PageOrientation createPageOrientation(String orientation) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating page orientation for #0", new Object[]{orientation});
        }
        try {
            return orientation == null ? PageOrientation.LANDSCAPE : (PageOrientation)JXLExcelFactory.getConstant(JXL_PAGE_ORIENTATION_CLASS_NAME, orientation.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Page orientation {0} not supported, try {1}", new Object[]{orientation, JXLExcelFactory.getValidConstants(JXL_PAGE_ORIENTATION_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static PaperSize createPaperSize(String paperSize) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating paper size for #0", new Object[]{paperSize});
        }
        try {
            return paperSize == null ? PaperSize.A4 : (PaperSize)JXLExcelFactory.getConstant(JXL_PAPER_SIZE_CLASS_NAME, paperSize.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Page size {0} not supported, try {1}", new Object[]{paperSize, JXLExcelFactory.getValidConstants(JXL_PAPER_SIZE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static HeaderFooter createHeaderFooter(UIHeaderFooter uiHeaderFooter, HeaderFooter headerFooter) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing header/footer #0", new Object[]{uiHeaderFooter});
        }
        JXLExcelFactory.processHeaderFooterFacet(headerFooter.getLeft(), uiHeaderFooter.getFacet("left"));
        JXLExcelFactory.processHeaderFooterFacet(headerFooter.getCentre(), uiHeaderFooter.getFacet("center"));
        JXLExcelFactory.processHeaderFooterFacet(headerFooter.getRight(), uiHeaderFooter.getFacet("right"));
        return headerFooter;
    }

    private static void processHeaderFooterFacet(HeaderFooter.Contents contents, UIComponent facet) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing facet #0 of header/footer #1", new Object[]{facet, contents});
        }
        if (facet == null) {
            return;
        }
        for (UIComponent child : facet.getChildren()) {
            if (child.getClass() != UIHeaderFooterCommand.class) continue;
            JXLExcelFactory.processHeaderFooterCommand(contents, (UIHeaderFooterCommand)child);
        }
    }

    private static void processHeaderFooterCommand(HeaderFooter.Contents contents, UIHeaderFooterCommand command) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing header/footer command #0", new Object[]{command});
        }
        switch (command.getCommand()) {
            case append: {
                contents.append((String)command.getParameter());
                break;
            }
            case date: {
                contents.appendDate();
                break;
            }
            case page_number: {
                contents.appendPageNumber();
                break;
            }
            case time: {
                contents.appendTime();
                break;
            }
            case total_pages: {
                contents.appendTotalPages();
                break;
            }
            case workbook_name: {
                contents.appendWorkbookName();
                break;
            }
            case worksheet_name: {
                contents.appendWorkSheetName();
                break;
            }
            case font_name: {
                contents.setFontName((String)command.getParameter());
                break;
            }
            case font_size: {
                contents.setFontSize(((Integer)command.getParameter()).intValue());
                break;
            }
            case toggle_bold: {
                contents.toggleBold();
                break;
            }
            case toggle_italics: {
                contents.toggleItalics();
                break;
            }
            case toggle_double_underline: {
                contents.toggleDoubleUnderline();
                break;
            }
            case toggle_outline: {
                contents.toggleOutline();
                break;
            }
            case toggle_shadow: {
                contents.toggleShadow();
                break;
            }
            case toggle_strikethrough: {
                contents.toggleStrikethrough();
                break;
            }
            case toggle_subscript: {
                contents.toggleSubScript();
                break;
            }
            case toggle_superscript: {
                contents.toggleSuperScript();
                break;
            }
            default: {
                String message = Interpolator.instance().interpolate("Header/Footer command {0} not supported, try {1}", new Object[]{command.getCommand(), JXLExcelFactory.getValidConstants(HEADER_FOOTER_COMMAND_CLASS_NAME)});
                throw new ExcelWorkbookException(message);
            }
        }
    }

    public static void applyColumnSettings(UIColumn uiColumn, WritableSheet worksheet, int columnIndex) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Applying column settings #0 on column #1", new Object[]{uiColumn, columnIndex});
        }
        CellView cellView = worksheet.getColumnView(columnIndex);
        if (uiColumn.getAutoSize() != null) {
            cellView.setAutosize(uiColumn.getAutoSize().booleanValue());
        }
        if (uiColumn.getHidden() != null) {
            cellView.setHidden(uiColumn.getHidden().booleanValue());
        }
        if (uiColumn.getWidth() != null) {
            cellView.setSize(uiColumn.getWidth().intValue());
        }
        worksheet.setColumnView(columnIndex, cellView);
    }

    public static void applyWorksheetSettings(SheetSettings oldSettings, UIWorksheetSettings template) {
        if (template.getAutomaticFormulaCalculation() != null) {
            oldSettings.setAutomaticFormulaCalculation(template.getAutomaticFormulaCalculation().booleanValue());
        }
        if (template.getBottomMargin() != null) {
            oldSettings.setBottomMargin(template.getBottomMargin().doubleValue());
        }
        if (template.getCopies() != null) {
            oldSettings.setCopies(template.getCopies().intValue());
        }
        if (template.getDefaultColumnWidth() != null) {
            oldSettings.setDefaultColumnWidth(template.getDefaultColumnWidth().intValue());
        }
        if (template.getDefaultRowHeight() != null) {
            oldSettings.setDefaultRowHeight(template.getDefaultRowHeight().intValue());
        }
        if (template.getDisplayZeroValues() != null) {
            oldSettings.setDisplayZeroValues(template.getDisplayZeroValues().booleanValue());
        }
        if (template.getFitHeight() != null) {
            oldSettings.setFitHeight(template.getFitHeight().intValue());
        }
        if (template.getFitToPages() != null) {
            oldSettings.setFitToPages(template.getFitToPages().booleanValue());
        }
        if (template.getFitWidth() != null) {
            oldSettings.setFitWidth(template.getFitWidth().intValue());
        }
        if (template.getFooterMargin() != null) {
            oldSettings.setFooterMargin(template.getFooterMargin().doubleValue());
        }
        if (template.getHeaderMargin() != null) {
            oldSettings.setHeaderMargin(template.getHeaderMargin().doubleValue());
        }
        if (template.getHidden() != null) {
            oldSettings.setHidden(template.getHidden().booleanValue());
        }
        if (template.getHorizontalCentre() != null) {
            oldSettings.setHorizontalCentre(template.getHorizontalCentre().booleanValue());
        }
        if (template.getHorizontalFreeze() != null) {
            oldSettings.setHorizontalFreeze(template.getHorizontalFreeze().intValue());
        }
        if (template.getHorizontalPrintResolution() != null) {
            oldSettings.setHorizontalPrintResolution(template.getHorizontalPrintResolution().intValue());
        }
        if (template.getLeftMargin() != null) {
            oldSettings.setLeftMargin(template.getLeftMargin().doubleValue());
        }
        if (template.getNormalMagnification() != null) {
            oldSettings.setNormalMagnification(template.getNormalMagnification().intValue());
        }
        if (template.getOrientation() != null) {
            oldSettings.setOrientation(JXLExcelFactory.createPageOrientation(template.getOrientation()));
        }
        if (template.getPageBreakPreviewMagnification() != null) {
            oldSettings.setPageBreakPreviewMagnification(template.getPageBreakPreviewMagnification().intValue());
        }
        if (template.getPageBreakPreviewMode() != null) {
            oldSettings.setPageBreakPreviewMode(template.getPageBreakPreviewMode().booleanValue());
        }
        if (template.getPageStart() != null) {
            oldSettings.setPageStart(template.getPageStart().intValue());
        }
        if (template.getPaperSize() != null) {
            oldSettings.setPaperSize(JXLExcelFactory.createPaperSize(template.getPaperSize()));
        }
        if (template.getPassword() != null) {
            oldSettings.setPassword(template.getPassword());
        }
        if (template.getPasswordHash() != null) {
            oldSettings.setPasswordHash(template.getPasswordHash().intValue());
        }
        if (template.getPrintGridLines() != null) {
            oldSettings.setPrintGridLines(template.getPrintGridLines().booleanValue());
        }
        if (template.getPrintHeaders() != null) {
            oldSettings.setPrintHeaders(template.getPrintHeaders().booleanValue());
        }
        if (template.getSheetProtected() != null) {
            oldSettings.setProtected(template.getSheetProtected().booleanValue());
        }
        if (template.getRecalculateFormulasBeforeSave() != null) {
            oldSettings.setRecalculateFormulasBeforeSave(template.getRecalculateFormulasBeforeSave().booleanValue());
        }
        if (template.getRightMargin() != null) {
            oldSettings.setRightMargin(template.getRightMargin().doubleValue());
        }
        if (template.getScaleFactor() != null) {
            oldSettings.setScaleFactor(template.getScaleFactor().intValue());
        }
        if (template.getSelected() != null) {
            oldSettings.setSelected(template.getSelected().booleanValue());
        }
        if (template.getShowGridLines() != null) {
            oldSettings.setShowGridLines(template.getShowGridLines().booleanValue());
        }
        if (template.getTopMargin() != null) {
            oldSettings.setTopMargin(template.getTopMargin().doubleValue());
        }
        if (template.getVerticalCentre() != null) {
            oldSettings.setVerticalCentre(template.getVerticalCentre().booleanValue());
        }
        if (template.getVerticalFreeze() != null) {
            oldSettings.setVerticalFreeze(template.getVerticalFreeze().intValue());
        }
        if (template.getVerticalPrintResolution() != null) {
            oldSettings.setVerticalPrintResolution(template.getVerticalPrintResolution().intValue());
        }
        if (template.getZoomFactor() != null) {
            oldSettings.setZoomFactor(template.getZoomFactor().intValue());
        }
        block4: for (UIComponent child : template.getChildren()) {
            if (child.getClass() == UIPrintArea.class) {
                UIPrintArea printArea = (UIPrintArea)child;
                oldSettings.setPrintArea(printArea.getFirstColumn().intValue(), printArea.getFirstRow().intValue(), printArea.getLastColumn().intValue(), printArea.getLastRow().intValue());
                continue;
            }
            if (child.getClass() == UIPrintTitles.class) {
                UIPrintTitles printTitles = (UIPrintTitles)child;
                oldSettings.setPrintTitles(printTitles.getFirstCol().intValue(), printTitles.getFirstRow().intValue(), printTitles.getLastCol().intValue(), printTitles.getLastRow().intValue());
                continue;
            }
            if (child.getClass() != UIHeaderFooter.class) continue;
            UIHeaderFooter headerFooter = (UIHeaderFooter)child;
            switch (headerFooter.getType()) {
                case header: {
                    oldSettings.setHeader(JXLExcelFactory.createHeaderFooter(headerFooter, oldSettings.getHeader()));
                    continue block4;
                }
                case footer: {
                    oldSettings.setFooter(JXLExcelFactory.createHeaderFooter(headerFooter, oldSettings.getFooter()));
                    continue block4;
                }
            }
            throw new ExcelWorkbookException("Header/Footer type " + (Object)((Object)headerFooter.getType()) + " not supported, try [header, footer]");
        }
    }

    public static WritableCell createCell(int column, int row, UICell.CellType type, Object data, WritableCellFormat cellFormat) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating cell at (#0,#1) of type #2 with data #2", new Object[]{column, row, type, data});
        }
        switch (type) {
            case text: {
                return new Label(column, row, data.toString(), (CellFormat)cellFormat);
            }
            case number: {
                return new Number(column, row, Double.parseDouble(data.toString()), (CellFormat)cellFormat);
            }
            case date: {
                return new DateTime(column, row, (Date)data, (CellFormat)cellFormat);
            }
            case formula: {
                return new Formula(column, row, data.toString(), (CellFormat)cellFormat);
            }
            case bool: {
                return new Boolean(column, row, java.lang.Boolean.parseBoolean(data.toString()), (CellFormat)cellFormat);
            }
        }
        return new Label(column, row, data.toString(), (CellFormat)cellFormat);
    }

    private static WritableFont createFont(UIFont uiFont, Font templateFont) throws WriteException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating font for #0", new Object[]{uiFont});
        }
        WritableFont font = null;
        font = uiFont.getName() != null ? new WritableFont(WritableFont.createFont((String)uiFont.getName())) : (templateFont != null ? new WritableFont(templateFont) : new WritableFont(WritableFont.ARIAL));
        if (uiFont.getColor() != null) {
            font.setColour(JXLExcelFactory.createColor(uiFont.getColor()));
        }
        if (uiFont.getPointSize() != null) {
            font.setPointSize(uiFont.getPointSize().intValue());
        }
        if (uiFont.getBold() != null) {
            font.setBoldStyle(uiFont.getBold() != false ? WritableFont.BOLD : WritableFont.NO_BOLD);
        }
        if (uiFont.getItalic() != null) {
            font.setItalic(uiFont.getItalic().booleanValue());
        }
        if (uiFont.getStruckOut() != null) {
            font.setStruckout(uiFont.getStruckOut().booleanValue());
        }
        if (uiFont.getScriptStyle() != null) {
            font.setScriptStyle(JXLExcelFactory.createScriptStyle(uiFont.getScriptStyle()));
        }
        if (uiFont.getUnderlineStyle() != null) {
            font.setUnderlineStyle(JXLExcelFactory.createUnderlineStyle(uiFont.getUnderlineStyle()));
        }
        return font;
    }

    private static DisplayFormat createNumberFormat(String mask) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating number format for mask #0", new Object[]{mask});
        }
        try {
            return (DisplayFormat)JXLExcelFactory.getConstant("jxl.write.NumberFormats", mask);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static DisplayFormat createDateFormat(String mask) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating date format for mask #0", new Object[]{mask});
        }
        try {
            return (DisplayFormat)JXLExcelFactory.getConstant("jxl.write.DateFormats", mask.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static VerticalAlignment createVerticalAlignment(String verticalAlignment) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating verical alignment for #0", new Object[]{verticalAlignment});
        }
        try {
            return verticalAlignment == null ? VerticalAlignment.BOTTOM : (VerticalAlignment)JXLExcelFactory.getConstant(JXL_VERTICAL_ALIGNMENT_CLASS_NAME, verticalAlignment.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Verical alignment {0} not supported, try {1}", new Object[]{verticalAlignment, JXLExcelFactory.getValidConstants(JXL_VERTICAL_ALIGNMENT_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static Orientation createOrientation(String orientation) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating orientation for #0", new Object[]{orientation});
        }
        try {
            return orientation == null ? Orientation.HORIZONTAL : (Orientation)JXLExcelFactory.getConstant(JXL_ORIENTATION_CLASS_NAME, orientation.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Orientation {0} not supported, try {1}", new Object[]{orientation, JXLExcelFactory.getValidConstants(JXL_ORIENTATION_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static Alignment createAlignment(String alignment) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating alignment for #0", new Object[]{alignment});
        }
        try {
            return alignment == null ? Alignment.LEFT : (Alignment)JXLExcelFactory.getConstant(JXL_ALIGNMENT_CLASS_NAME, alignment.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Alignment {0} not supported, try {1}", new Object[]{alignment, JXLExcelFactory.getValidConstants(JXL_ALIGNMENT_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static Pattern createPattern(String pattern) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating pattern for #0", new Object[]{pattern});
        }
        try {
            return pattern == null ? Pattern.SOLID : (Pattern)JXLExcelFactory.getConstant(JXL_PATTERN_CLASS_NAME, pattern.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Pattern {0} not supported, try {1}", new Object[]{pattern, JXLExcelFactory.getValidConstants(JXL_PATTERN_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static BorderLineStyle createBorderLineStyle(String borderLineStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating border line style for #0", new Object[]{borderLineStyle});
        }
        try {
            return borderLineStyle == null ? BorderLineStyle.NONE : (BorderLineStyle)JXLExcelFactory.getConstant(JXL_BORDER_LINE_STYLE_CLASS_NAME, borderLineStyle.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Border line style {0} not supported, try {1}", new Object[]{borderLineStyle, JXLExcelFactory.getValidConstants(JXL_BORDER_LINE_STYLE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static Border createBorder(String border) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating border for #0", new Object[]{border});
        }
        try {
            return border == null ? Border.ALL : (Border)JXLExcelFactory.getConstant(JXL_BORDER_CLASS_NAME, border.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Border {0} not supported, try {1}", new Object[]{border, JXLExcelFactory.getValidConstants(JXL_BORDER_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static UnderlineStyle createUnderlineStyle(String underlineStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating underline style for #0", new Object[]{underlineStyle});
        }
        try {
            return underlineStyle == null ? UnderlineStyle.NO_UNDERLINE : (UnderlineStyle)JXLExcelFactory.getConstant(JXL_UNDERLINE_STYLE_CLASS_NAME, underlineStyle.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Underline style {0} not supported, try {1}", new Object[]{underlineStyle, JXLExcelFactory.getValidConstants(JXL_UNDERLINE_STYLE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static ScriptStyle createScriptStyle(String scriptStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating script style for #0", new Object[]{scriptStyle});
        }
        try {
            return scriptStyle == null ? ScriptStyle.NORMAL_SCRIPT : (ScriptStyle)JXLExcelFactory.getConstant(JXL_SCRIPT_STYLE_CLASS_NAME, scriptStyle.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Script style {0} not supported, try {1}", new Object[]{scriptStyle, JXLExcelFactory.getValidConstants(JXL_SCRIPT_STYLE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static Colour createColor(String color) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating color for #0", new Object[]{color});
        }
        if (color.equalsIgnoreCase("black")) {
            color = "palette_black";
        }
        try {
            return color == null ? Colour.AUTOMATIC : (Colour)JXLExcelFactory.getConstant(JXL_COLOR_CLASS_NAME, color.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Color {0} not supported, try {1}", new Object[]{color, JXLExcelFactory.getValidConstants(JXL_COLOR_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static void addListValidation(WritableCellFeatures cellFeatures, UIListValidation validation) {
        List<UIListValidationItem> items = ExcelComponent.getChildrenOfType(validation.getChildren(), UIListValidationItem.class);
        if (items.isEmpty()) {
            throw new ExcelWorkbookException("No items in validation list");
        }
        ArrayList<String> validations = new ArrayList<String>();
        for (UIListValidationItem item : items) {
            validations.add(item.getValue());
        }
        cellFeatures.setDataValidationList(validations);
    }

    private static void addRangeValidation(WritableCellFeatures cellFeatures, UIRangeValidation validation) {
        if (validation.getStartColumn() == null || validation.getStartRow() == null || validation.getEndColumn() == null || validation.getEndRow() == null) {
            throw new ExcelWorkbookException("Must set all start/end columns/rows for range validation");
        }
        cellFeatures.setDataValidationRange(validation.getStartColumn().intValue(), validation.getStartRow().intValue(), validation.getEndColumn().intValue(), validation.getEndRow().intValue());
    }

    private static void addNumericValidation(WritableCellFeatures cellFeatures, UINumericValidation validation) {
        if (validation.getValue() == null) {
            throw new ExcelWorkbookException("Must define value in validation");
        }
        if ((UINumericValidation.ValidationCondition.between.equals((Object)validation.getCondition()) || UINumericValidation.ValidationCondition.not_between.equals((Object)validation.getCondition())) && validation.getValue2() == null) {
            throw new ExcelWorkbookException("Must define both values in validation for between/not_between");
        }
        switch (validation.getCondition()) {
            case equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.EQUAL);
                break;
            }
            case not_equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.NOT_EQUAL);
                break;
            }
            case greater_equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.GREATER_EQUAL);
                break;
            }
            case less_equal: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.LESS_EQUAL);
                break;
            }
            case less_than: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), WritableCellFeatures.LESS_THAN);
                break;
            }
            case between: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), validation.getValue2().doubleValue(), WritableCellFeatures.BETWEEN);
                break;
            }
            case not_between: {
                cellFeatures.setNumberValidation(validation.getValue().doubleValue(), validation.getValue2().doubleValue(), WritableCellFeatures.NOT_BETWEEN);
            }
        }
    }

    public static WritableCellFormat createCellFormat(UICellFormat mergeCellFormat, WritableCellFormat templateCellFormat, UICell.CellType dataType) throws WriteException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating cell format for #0 with type #1 and template #2", new Object[]{mergeCellFormat, dataType, templateCellFormat});
        }
        WritableCellFormat cellFormat = null;
        switch (dataType) {
            case text: {
                cellFormat = templateCellFormat == null ? new WritableCellFormat(NumberFormats.TEXT) : new WritableCellFormat((CellFormat)templateCellFormat);
                break;
            }
            case number: {
                if (mergeCellFormat.getMask() == null) {
                    cellFormat = templateCellFormat == null ? new WritableCellFormat(NumberFormats.DEFAULT) : new WritableCellFormat((CellFormat)templateCellFormat);
                    break;
                }
                DisplayFormat displayFormat = JXLExcelFactory.createNumberFormat(mergeCellFormat.getMask());
                if (displayFormat != null) {
                    cellFormat = mergeCellFormat == null ? new WritableCellFormat(displayFormat) : new WritableCellFormat((CellFormat)templateCellFormat);
                    break;
                }
                try {
                    cellFormat = templateCellFormat == null ? new WritableCellFormat((DisplayFormat)new NumberFormat(mergeCellFormat.getMask())) : new WritableCellFormat((CellFormat)templateCellFormat);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not create number format for mask {0}", new Object[]{mergeCellFormat.getMask()}), e);
                }
            }
            case date: {
                if (mergeCellFormat.getMask() == null) {
                    cellFormat = templateCellFormat == null ? new WritableCellFormat(DateFormats.DEFAULT) : new WritableCellFormat((CellFormat)templateCellFormat);
                    break;
                }
                DisplayFormat displayFormat = JXLExcelFactory.createDateFormat(mergeCellFormat.getMask());
                if (displayFormat != null) {
                    cellFormat = templateCellFormat == null ? new WritableCellFormat(displayFormat) : new WritableCellFormat((CellFormat)templateCellFormat);
                    break;
                }
                try {
                    cellFormat = templateCellFormat == null ? new WritableCellFormat((DisplayFormat)new DateFormat(mergeCellFormat.getMask())) : new WritableCellFormat((CellFormat)templateCellFormat);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not create date format for mask {0}", new Object[]{mergeCellFormat.getMask()}), e);
                }
            }
            case formula: {
                cellFormat = templateCellFormat == null ? new WritableCellFormat() : new WritableCellFormat((CellFormat)templateCellFormat);
                break;
            }
            case bool: {
                cellFormat = templateCellFormat == null ? new WritableCellFormat() : new WritableCellFormat((CellFormat)templateCellFormat);
                break;
            }
            default: {
                WritableCellFormat writableCellFormat = cellFormat = templateCellFormat == null ? new WritableCellFormat() : new WritableCellFormat((CellFormat)templateCellFormat);
            }
        }
        if (mergeCellFormat.getAlignment() != null) {
            cellFormat.setAlignment(JXLExcelFactory.createAlignment(mergeCellFormat.getAlignment()));
        }
        if (mergeCellFormat.getIndentation() != null) {
            cellFormat.setIndentation(mergeCellFormat.getIndentation().intValue());
        }
        if (mergeCellFormat.getLocked() != null) {
            cellFormat.setLocked(mergeCellFormat.getLocked().booleanValue());
        }
        if (mergeCellFormat.getOrientation() != null) {
            cellFormat.setOrientation(JXLExcelFactory.createOrientation(mergeCellFormat.getOrientation()));
        }
        if (mergeCellFormat.getShrinkToFit() != null) {
            cellFormat.setShrinkToFit(mergeCellFormat.getShrinkToFit().booleanValue());
        }
        if (mergeCellFormat.getVerticalAlignment() != null) {
            cellFormat.setVerticalAlignment(JXLExcelFactory.createVerticalAlignment(mergeCellFormat.getVerticalAlignment()));
        }
        if (mergeCellFormat.getWrap() != null) {
            cellFormat.setWrap(mergeCellFormat.getWrap().booleanValue());
        }
        for (UIComponent child : mergeCellFormat.getChildren()) {
            if (child instanceof UIFont) {
                Font templateFont = templateCellFormat == null ? null : templateCellFormat.getFont();
                cellFormat.setFont((FontRecord)JXLExcelFactory.createFont((UIFont)child, templateFont));
                continue;
            }
            if (child.getClass() == UIBorder.class) {
                cellFormat.setBorder(JXLExcelFactory.createBorder(((UIBorder)child).getBorder()), JXLExcelFactory.createBorderLineStyle(((UIBorder)child).getLineStyle()), JXLExcelFactory.createColor(((UIBorder)child).getColor()));
                continue;
            }
            if (child.getClass() != UIBackground.class) continue;
            cellFormat.setBackground(JXLExcelFactory.createColor(((UIBackground)child).getColor()), JXLExcelFactory.createPattern(((UIBackground)child).getPattern()));
        }
        return cellFormat;
    }

    public static WritableCellFeatures createCellFeatures(UICellFormat uiCellFormat, CellFeatures template) {
        WritableCellFeatures cellFeatures;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating cell features for #0", new Object[]{uiCellFormat});
        }
        WritableCellFeatures writableCellFeatures = cellFeatures = template != null ? new WritableCellFeatures(template) : new WritableCellFeatures();
        if (uiCellFormat.getComment() != null) {
            if (uiCellFormat.getCommentHeight() != null && uiCellFormat.getCommentWidth() != null) {
                cellFeatures.setComment(uiCellFormat.getComment(), (double)uiCellFormat.getCommentWidth().intValue(), (double)uiCellFormat.getCommentHeight().intValue());
            } else {
                cellFeatures.setComment(uiCellFormat.getComment());
            }
        }
        List<Validation> validations = ExcelComponent.getChildrenOfType(uiCellFormat.getChildren(), Validation.class);
        block5: for (Validation validation : validations) {
            switch (validation.getType()) {
                case numeric: {
                    JXLExcelFactory.addNumericValidation(cellFeatures, (UINumericValidation)validation);
                    continue block5;
                }
                case range: {
                    JXLExcelFactory.addRangeValidation(cellFeatures, (UIRangeValidation)validation);
                    continue block5;
                }
                case list: {
                    JXLExcelFactory.addListValidation(cellFeatures, (UIListValidation)validation);
                    continue block5;
                }
            }
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Unknown validation type {0}", new Object[]{validation.getType()}));
        }
        return cellFeatures;
    }

    protected static Object getConstant(String className, String fieldName) throws NoSuchFieldException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Looking for constant #0 in class #1", new Object[]{fieldName, className});
        }
        try {
            return Class.forName(className).getField(fieldName).get(null);
        }
        catch (NoSuchFieldException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not read field #0 from class #1", new Object[]{fieldName, className}), e);
        }
    }

    protected static String getValidConstants(String className) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Getting valid constants from #0", new Object[]{className});
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ExcelWorkbookException("Could not find class while getting valid constants", e);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (Field field : clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            String name = field.getName().toLowerCase();
            buffer.append(i++ == 0 ? name : ", " + name);
        }
        return Interpolator.instance().interpolate("[#0]", new Object[]{buffer.toString()});
    }
}

