/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.ui;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.jboss.seam.excel.Command;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.UIWorksheetSettings;
import org.jboss.seam.framework.Query;

public class UIWorksheet
extends UIWorksheetSettings {
    public static final String COMPONENT_TYPE = "org.jboss.seam.excel.ui.UIWorksheet";
    private String name;
    private String var;
    private Object value;
    private Integer startRow;
    private Integer startColumn;
    private String templates;

    public Integer getStartRow() {
        return (Integer)this.valueOf("startRow", this.startRow);
    }

    public void setStartRow(Integer startRow) {
        this.startRow = startRow;
    }

    public Integer getStartColumn() {
        return (Integer)this.valueOf("startColumn", this.startColumn);
    }

    public void setStartColumn(Integer startColumn) {
        this.startColumn = startColumn;
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public String getName() {
        return (String)this.valueOf("name", this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVar() {
        return (String)this.valueOf("var", this.var);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public Object getValue() {
        return this.valueOf("value", this.value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setTemplates(String templates) {
        this.templates = templates;
    }

    public String getTemplates() {
        return (String)this.valueOf("templates", this.templates);
    }

    public void encodeBegin(FacesContext arg0) throws IOException {
        ExcelWorkbook excelWorkbook = this.getWorkbook(this.getParent());
        if (excelWorkbook == null) {
            throw new ExcelWorkbookException("Could not find excel workbook");
        }
        excelWorkbook.createOrSelectWorksheet(this);
        List<WorksheetItem> items = UIWorksheet.getItems(this.getChildren());
        for (WorksheetItem item : items) {
            excelWorkbook.addItem(item);
        }
        List<Command> commands = UIWorksheet.getCommands(this.getChildren());
        for (Command command : commands) {
            excelWorkbook.executeCommand(command);
        }
    }

    public static Iterator unwrapIterator(Object value) {
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value instanceof DataModel && ((DataModel)value).getWrappedData() instanceof Iterable) {
            return ((Iterable)((DataModel)value).getWrappedData()).iterator();
        }
        if (value instanceof Query) {
            return ((Query)value).getResultList().iterator();
        }
        if (value != null && value.getClass().isArray()) {
            return UIWorksheet.arrayAsList(value).iterator();
        }
        throw new ExcelWorkbookException("A worksheet's value must be an Iterable, DataModel or Query");
    }

    public Iterator getDataIterator() {
        return UIWorksheet.unwrapIterator(this.getValue());
    }

    private static List arrayAsList(Object array) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(array); ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }
}

