/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Asynchronous;
import org.jboss.seam.async.AsynchronousEvent;
import org.jboss.seam.async.AsynchronousInvocation;
import org.jboss.seam.async.Dispatcher;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.intercept.InvocationContext;
import org.springframework.core.task.TaskExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.async.dispatcher")
@Install(value=false, precedence=0)
public class SpringTaskExecutorDispatcher<T, S>
extends AbstractDispatcher<T, S> {
    private Expressions.ValueExpression<Dispatcher<T, S>> scheduleDispatcher;
    private Expressions.ValueExpression<TaskExecutor> taskExecutor;

    public T scheduleAsynchronousEvent(String type, Object ... parameters) {
        ((TaskExecutor)this.taskExecutor.getValue()).execute((Runnable)new RunnableAsynchronous((Asynchronous)new AsynchronousEvent(type, parameters)));
        return null;
    }

    public T scheduleInvocation(InvocationContext invocation, Component component) {
        Schedule schedule = this.createSchedule(invocation);
        if (!TimerSchedule.ONCE_IMMEDIATELY.equals((Object)schedule)) {
            return (T)this.getScheduleDispatcher().scheduleInvocation(invocation, component);
        }
        ((TaskExecutor)this.taskExecutor.getValue()).execute((Runnable)new RunnableAsynchronous((Asynchronous)new AsynchronousInvocation(invocation, component)));
        return null;
    }

    public T scheduleTimedEvent(String type, S schedule, Object ... parameters) {
        return (T)this.getScheduleDispatcher().scheduleTimedEvent(type, schedule, parameters);
    }

    protected Dispatcher<T, S> getScheduleDispatcher() {
        Dispatcher dispatcher = (Dispatcher)this.scheduleDispatcher.getValue();
        if (this.scheduleDispatcher == null || this.scheduleDispatcher.getValue() == null) {
            throw new IllegalStateException("SpringTaskExecutorDispatcher does not support scheduled Events.  Provide a fallback scheduleDispatcher for timed events.");
        }
        return dispatcher;
    }

    public void setScheduleDispatcher(Expressions.ValueExpression<Dispatcher<T, S>> scheduleDispatcher) {
        this.scheduleDispatcher = scheduleDispatcher;
    }

    public void setTaskExecutor(Expressions.ValueExpression<TaskExecutor> taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    static class RunnableAsynchronous
    implements Runnable {
        private Asynchronous async;

        RunnableAsynchronous(Asynchronous async) {
            this.async = async;
        }

        public void run() {
            this.async.execute(null);
        }
    }
}

