/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.HeuristicCompletionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.transaction.transaction")
@Scope(value=ScopeType.EVENT)
@Install(value=false, precedence=10)
@BypassInterceptors
public class SpringTransaction
extends AbstractUserTransaction {
    private static final LogProvider log = Logging.getLogProvider(SpringTransaction.class);
    private Expressions.ValueExpression<PlatformTransactionManager> platformTransactionManager;
    private DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
    private boolean conversationContextRequired = true;
    private TransactionStatus currentTransaction;
    private Boolean joinTransaction;

    public void registerSynchronization(Synchronization sync) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("TransactionSynchronization not available with this Spring Transaction Manager");
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new JtaSpringSynchronizationAdapter(sync));
    }

    public void begin() throws NotSupportedException, SystemException {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new NotSupportedException("A Spring transaction is already active.");
        }
        this.currentTransaction = ((PlatformTransactionManager)this.platformTransactionManager.getValue()).getTransaction((TransactionDefinition)this.definition);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.assertActive();
        try {
            ((PlatformTransactionManager)this.platformTransactionManager.getValue()).commit(this.currentTransaction);
        }
        catch (HeuristicCompletionException e) {
            switch (e.getOutcomeState()) {
                case 2: {
                    log.error((Object)"Exception cause:", (Throwable)e);
                    throw new HeuristicRollbackException(e.getMessage());
                }
            }
            log.error((Object)"Exception cause:", (Throwable)e);
            throw new HeuristicMixedException(e.getMessage());
        }
        catch (TransactionSystemException e) {
            log.error((Object)"Exception cause:", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (UnexpectedRollbackException e) {
            log.error((Object)"Exception cause:", (Throwable)e);
            throw new RollbackException(e.getMessage());
        }
        finally {
            this.currentTransaction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() throws SystemException {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionStatus transaction = null;
            try {
                if (this.currentTransaction == null) {
                    transaction = ((PlatformTransactionManager)this.platformTransactionManager.getValue()).getTransaction((TransactionDefinition)this.definition);
                    if (transaction.isNewTransaction()) {
                        int n = 3;
                        return n;
                    }
                } else {
                    transaction = this.currentTransaction;
                }
                if (transaction.isCompleted()) {
                    if (transaction.isRollbackOnly()) {
                        int n = 4;
                        return n;
                    }
                    int n = 3;
                    return n;
                }
                if (transaction.isRollbackOnly()) {
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                if (this.currentTransaction == null) {
                    ((PlatformTransactionManager)this.platformTransactionManager.getValue()).commit(transaction);
                }
            }
        }
        return 6;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.assertActive();
        try {
            ((PlatformTransactionManager)this.platformTransactionManager.getValue()).rollback(this.currentTransaction);
        }
        catch (TransactionException e) {
            log.error((Object)"Exception cause:", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        finally {
            this.currentTransaction = null;
        }
    }

    private void assertActive() {
        if (!TransactionSynchronizationManager.isActualTransactionActive() || this.currentTransaction == null) {
            throw new IllegalStateException("No transaction currently active that Seam started.Seam should only be able to committ or rollback transactions it started.");
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalStateException("No Spring Transaction is currently available.");
        }
        TransactionStatus transaction = null;
        try {
            transaction = this.currentTransaction == null ? ((PlatformTransactionManager)this.platformTransactionManager.getValue()).getTransaction((TransactionDefinition)this.definition) : this.currentTransaction;
            transaction.setRollbackOnly();
        }
        catch (TransactionException e) {
            log.error((Object)"Exception cause:", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        finally {
            if (this.currentTransaction == null) {
                ((PlatformTransactionManager)this.platformTransactionManager.getValue()).commit(transaction);
            }
        }
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            return;
        }
        this.definition.setTimeout(timeout);
    }

    public void enlist(EntityManager entityManager) throws SystemException {
        if (this.joinTransaction == null) {
            if (!(this.platformTransactionManager.getValue() instanceof JpaTransactionManager)) {
                super.enlist(entityManager);
            }
        } else if (this.joinTransaction.booleanValue()) {
            super.enlist(entityManager);
        }
    }

    @Destroy
    public void cleanupCurrentTransaction() {
        if (this.currentTransaction != null) {
            try {
                log.debug((Object)"Attempting to rollback left over transaction.  Should never be called.");
                ((PlatformTransactionManager)this.platformTransactionManager.getValue()).rollback(this.currentTransaction);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setPlatformTransactionManager(Expressions.ValueExpression<PlatformTransactionManager> platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    public boolean isConversationContextRequired() {
        return this.conversationContextRequired;
    }

    public void setConversationContextRequired(boolean conversationContextRequired) {
        this.conversationContextRequired = conversationContextRequired;
    }

    public void setJoinTransaction(Boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public class JtaSpringSynchronizationAdapter
    extends TransactionSynchronizationAdapter {
        private final Synchronization sync;

        public int getOrder() {
            return 0x7FFFFFFE;
        }

        public JtaSpringSynchronizationAdapter(Synchronization sync) {
            this.sync = sync;
        }

        public void afterCompletion(int status) {
            this.sync.afterCompletion(status);
        }

        public void beforeCompletion() {
            this.sync.beforeCompletion();
        }
    }
}

