/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.deployment.AnnotationDeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.ApplicationConfig;
import org.jboss.seam.util.Reflections;

@Name(value="org.jboss.seam.resteasy.bootstrap")
@Scope(value=ScopeType.APPLICATION)
@Startup
@AutoCreate
@Install(classDependencies={"org.resteasy.Dispatcher"})
public class ResteasyBootstrap {
    @Logger
    Log log;
    @In
    protected ApplicationConfig applicationConfig;

    @Create
    public void onStartup() {
        String[] applicationContextNames;
        this.log.info((Object)"deploying Resteasy providers and resources", new Object[0]);
        Collection annotatedProviderClasses = null;
        Collection annotatedResourceClasses = null;
        if (this.applicationConfig.isScanProviders() || this.applicationConfig.isScanResources()) {
            this.log.debug((Object)"scanning all classes for JAX-RS annotations", new Object[0]);
            DeploymentStrategy deployment = (DeploymentStrategy)Component.getInstance((String)"deploymentStrategy");
            AnnotationDeploymentHandler handler = (AnnotationDeploymentHandler)deployment.getDeploymentHandlers().get("org.jboss.seam.deployment.AnnotationDeploymentHandler");
            annotatedProviderClasses = (Collection)handler.getClassMap().get(Provider.class.getName());
            annotatedResourceClasses = (Collection)handler.getClassMap().get(Path.class.getName());
        }
        this.log.debug((Object)"finding all Seam component classes", new Object[0]);
        HashMap<Class, Component> seamComponents = new HashMap<Class, Component>();
        for (String applicationContextName : applicationContextNames = Contexts.getApplicationContext().getNames()) {
            if (!applicationContextName.endsWith(".component")) continue;
            Component seamComponent = (Component)Component.getInstance((String)applicationContextName, (ScopeType)ScopeType.APPLICATION);
            seamComponents.put(seamComponent.getBeanClass(), seamComponent);
        }
        this.registerProviders(seamComponents, annotatedProviderClasses);
        this.registerResources(seamComponents, annotatedResourceClasses);
    }

    protected void registerProviders(Map<Class, Component> seamComponents, Collection annotatedProviderClasses) {
        HashSet<Class> providerClasses = new HashSet<Class>();
        try {
            if (this.applicationConfig.isScanProviders() && annotatedProviderClasses != null) {
                providerClasses.addAll(annotatedProviderClasses);
            }
            for (String s : new HashSet<String>(this.applicationConfig.getProviderClassNames())) {
                providerClasses.add(Reflections.classForName((String)s));
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)("error loading JAX-RS provider class: " + ex.getMessage()), new Object[0]);
        }
        for (Class providerClass : providerClasses) {
            if (providerClass.getName().startsWith("org.resteasy.plugins.providers")) continue;
            Component seamComponent = null;
            if (seamComponents.containsKey(providerClass) && !(seamComponent = seamComponents.get(providerClass)).getScope().equals((Object)ScopeType.APPLICATION) && !seamComponent.getScope().equals((Object)ScopeType.STATELESS)) {
                this.log.warn((Object)("not registering as  provider Seam component, must be APPLICATION or STATELESS scoped: " + seamComponent.getName()), new Object[0]);
                seamComponent = null;
            }
            if (seamComponent != null) {
                this.log.debug((Object)("registering provider Seam component: " + seamComponent.getName()), new Object[0]);
            } else {
                this.log.debug((Object)("registering provider class: " + providerClass.getName()), new Object[0]);
            }
            this.applicationConfig.addProviderClass(providerClass, seamComponent);
        }
        if (this.applicationConfig.getProviderClasses().size() == 0 && !this.applicationConfig.isUseBuiltinProviders()) {
            this.log.info((Object)"no RESTEasy provider classes registered", new Object[0]);
        }
    }

    protected void registerResources(Map<Class, Component> seamComponents, Collection annotatedResourceClasses) {
        HashSet<Class> resourceClasses = new HashSet<Class>();
        try {
            if (this.applicationConfig.isScanResources() && annotatedResourceClasses != null) {
                resourceClasses.addAll(annotatedResourceClasses);
            }
            for (String s : new HashSet<String>(this.applicationConfig.getResourceClassNames())) {
                resourceClasses.add(Reflections.classForName((String)s));
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)("error loading JAX-RS resource class: " + ex.getMessage()), new Object[0]);
        }
        for (Class resourceClass : resourceClasses) {
            Component seamComponent = null;
            if (seamComponents.containsKey(resourceClass)) {
                seamComponent = seamComponents.get(resourceClass);
                this.log.debug((Object)("registering resource Seam component: " + seamComponent.getName()), new Object[0]);
            } else {
                this.log.debug((Object)("registering resource class with JAX-RS default lifecycle: " + resourceClass.getName()), new Object[0]);
            }
            this.applicationConfig.addResourceClass(resourceClass, seamComponent);
        }
        if (this.applicationConfig.getResourceClasses().size() == 0) {
            this.log.info((Object)"no JAX-RS resource classes registered", new Object[0]);
        }
    }
}

