/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource<T> {
    @Context
    private HttpHeaders httpHeaders;
    private String path = null;
    private MediaType[] mediaTypes = new MediaType[]{MediaType.APPLICATION_XML_TYPE};
    private Class entityClass = null;

    public MediaType[] getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(String[] mediaTypes) {
        this.mediaTypes = new MediaType[mediaTypes.length];
        for (int i = 0; i < mediaTypes.length; ++i) {
            this.mediaTypes[i] = MediaType.valueOf((String)mediaTypes[i]);
        }
    }

    public void setMediaTypes(MediaType[] mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public Class<T> getEntityClass() {
        if (this.entityClass == null) {
            ParameterizedType parameterizedSuperclass;
            Type superclass = this.getClass().getGenericSuperclass();
            if (superclass instanceof ParameterizedType && (parameterizedSuperclass = (ParameterizedType)superclass).getActualTypeArguments().length > 0) {
                return (Class)parameterizedSuperclass.getActualTypeArguments()[0];
            }
            throw new RuntimeException("Unable to determine entity class.");
        }
        return this.entityClass;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected MediaType selectResponseMediaType() {
        for (MediaType acceptedMediaType : this.httpHeaders.getAcceptableMediaTypes()) {
            for (MediaType availableMediaType : this.mediaTypes) {
                if (!acceptedMediaType.isCompatible(availableMediaType)) continue;
                return availableMediaType;
            }
        }
        return null;
    }

    public boolean isMediaTypeCompatible(MediaType mediaType) {
        for (MediaType availableMediaType : this.mediaTypes) {
            if (!availableMediaType.isCompatible(mediaType)) continue;
            return true;
        }
        return false;
    }
}

