/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.providers.jaxb.Wrapped;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.framework.EntityQuery;
import org.jboss.seam.framework.Query;
import org.jboss.seam.resteasy.AbstractResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="")
public class ResourceQuery<T>
extends AbstractResource<T> {
    private Query<?, T> entityQuery = null;

    @Create
    public void create() {
        this.entityQuery = this.getEntityQuery();
        if (this.entityQuery == null) {
            this.entityQuery = this.createEntityQuery();
        }
    }

    @GET
    @Wrapped
    public Response getResourceList(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="show") @DefaultValue(value="25") int show) {
        MediaType selectedMediaType = this.selectResponseMediaType();
        if (selectedMediaType == null) {
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
        }
        if (start < 0 || show < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        final List<T> result = this.getEntityList(start, show);
        ParameterizedType responseType = new ParameterizedType(){

            public Type getRawType() {
                return result.getClass();
            }

            public Type getOwnerType() {
                return null;
            }

            public Type[] getActualTypeArguments() {
                Type[] types = new Type[]{ResourceQuery.this.getEntityClass()};
                return types;
            }
        };
        return Response.ok((Object)new GenericEntity(result, responseType){}, (MediaType)selectedMediaType).build();
    }

    public List<T> getEntityList(int start, int show) {
        this.entityQuery.setFirstResult(Integer.valueOf(start));
        if (show > 0) {
            this.entityQuery.setMaxResults(Integer.valueOf(show));
        }
        return this.entityQuery.getResultList();
    }

    public Query<?, T> getEntityQuery() {
        return this.entityQuery;
    }

    public void setEntityQuery(Query<?, T> query) {
        this.entityQuery = query;
    }

    public Query<?, T> createEntityQuery() {
        EntityQuery entityQuery = new EntityQuery();
        entityQuery.setEjbql("select entity from " + this.getEntityClass().getName() + " entity");
        return entityQuery;
    }
}

