/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.deployment.AnnotationDeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.resteasy.bootstrap")
@Scope(value=ScopeType.APPLICATION)
@Startup
@AutoCreate
@Install(classDependencies={"org.jboss.resteasy.core.Dispatcher"})
public class ResteasyBootstrap {
    @Logger
    Log log;
    @In
    protected Application application;

    @Create
    public void onStartup() {
        String[] applicationContextNames;
        this.log.info((Object)"deploying RESTEasy providers and resources", new Object[0]);
        Collection annotatedProviderClasses = null;
        Collection annotatedResourceClasses = null;
        if (this.application.isScanProviders() || this.application.isScanResources()) {
            this.log.debug((Object)"scanning all classes for JAX-RS annotations", new Object[0]);
            DeploymentStrategy deployment = (DeploymentStrategy)Component.getInstance((String)"deploymentStrategy");
            AnnotationDeploymentHandler handler = (AnnotationDeploymentHandler)deployment.getDeploymentHandlers().get("org.jboss.seam.deployment.AnnotationDeploymentHandler");
            annotatedProviderClasses = (Collection)handler.getClassMap().get(Provider.class.getName());
            annotatedResourceClasses = (Collection)handler.getClassMap().get(Path.class.getName());
        }
        this.log.debug((Object)"finding all Seam component classes", new Object[0]);
        HashMap<Class, Set<Component>> seamComponents = new HashMap<Class, Set<Component>>();
        for (String applicationContextName : applicationContextNames = Contexts.getApplicationContext().getNames()) {
            if (!applicationContextName.endsWith(".component")) continue;
            Component seamComponent = (Component)Component.getInstance((String)applicationContextName, (ScopeType)ScopeType.APPLICATION);
            Class beanClass = seamComponent.getBeanClass();
            if (!seamComponents.containsKey(beanClass)) {
                seamComponents.put(beanClass, new HashSet());
            }
            ((Set)seamComponents.get(beanClass)).add(seamComponent);
        }
        this.registerProviders(seamComponents, annotatedProviderClasses);
        this.registerResources(seamComponents, annotatedResourceClasses);
    }

    protected void registerProviders(Map<Class, Set<Component>> seamComponents, Collection annotatedProviderClasses) {
        HashSet<Class> providerClasses = new HashSet<Class>();
        try {
            if (this.application.isScanProviders() && annotatedProviderClasses != null) {
                providerClasses.addAll(annotatedProviderClasses);
            }
            for (String s : new HashSet<String>(this.application.getProviderClassNames())) {
                providerClasses.add(Reflections.classForName((String)s));
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)("error loading JAX-RS provider class: " + ex.getMessage()), new Object[0]);
        }
        for (Class providerClass : providerClasses) {
            if (providerClass.getName().startsWith("org.jboss.resteasy.plugins.providers")) continue;
            if (seamComponents.containsKey(providerClass)) {
                for (Component seamComponent : seamComponents.get(providerClass)) {
                    if (!seamComponent.getScope().equals((Object)ScopeType.APPLICATION) && !seamComponent.getScope().equals((Object)ScopeType.STATELESS)) {
                        this.log.warn((Object)("can't add provider Seam component, not APPLICATION or STATELESS scope: " + seamComponent.getName()), new Object[0]);
                        this.log.warn((Object)"this provider class will be registered without Seam injection or lifecycle!", new Object[0]);
                        seamComponent = null;
                    }
                    if (seamComponent != null) {
                        this.log.debug((Object)("adding provider Seam component: " + seamComponent.getName()), new Object[0]);
                        this.application.addProviderClass(providerClass, seamComponent);
                        continue;
                    }
                    this.log.debug((Object)("adding provider class: " + providerClass.getName()), new Object[0]);
                    this.application.addProviderClass(providerClass);
                }
                continue;
            }
            this.log.debug((Object)("adding provider class: " + providerClass.getName()), new Object[0]);
            this.application.addProviderClass(providerClass);
        }
        if (this.application.getProviderClasses().size() == 0 && !this.application.isUseBuiltinProviders()) {
            this.log.info((Object)"no RESTEasy provider classes added", new Object[0]);
        }
    }

    protected void registerResources(Map<Class, Set<Component>> seamComponents, Collection annotatedResourceClasses) {
        HashSet<Class> resourceClasses = new HashSet<Class>();
        try {
            if (this.application.isScanResources() && annotatedResourceClasses != null) {
                resourceClasses.addAll(annotatedResourceClasses);
            }
            for (String s : new HashSet<String>(this.application.getResourceClassNames())) {
                resourceClasses.add(Reflections.classForName((String)s));
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)("error loading JAX-RS resource class: " + ex.getMessage()), new Object[0]);
        }
        for (Class resourceClass : resourceClasses) {
            if (seamComponents.containsKey(resourceClass)) {
                Set<Component> components = seamComponents.get(resourceClass);
                this.log.debug((Object)"adding resource Seam components {0} for class {1}", new Object[]{components, resourceClass});
                this.application.addResourceClass(resourceClass, components);
                continue;
            }
            this.log.debug((Object)("adding resource class with JAX-RS default lifecycle: " + resourceClass.getName()), new Object[0]);
            this.application.addResourceClass(resourceClass);
        }
        if (this.application.getClasses().size() == 0) {
            this.log.info((Object)"no JAX-RS resource classes registered", new Object[0]);
        }
    }
}

