/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.util.Set;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.AbstractResource;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.resteasy.ResourceHome;
import org.jboss.seam.resteasy.ResourceQuery;
import org.jboss.seam.resteasy.ResteasyContextInjectionInterceptor;

@Name(value="org.jboss.seam.resteasy.dispatcher")
@Scope(value=ScopeType.APPLICATION)
@Startup(depends={"org.jboss.seam.resteasy.bootstrap"})
@AutoCreate
@Install(classDependencies={"org.jboss.resteasy.core.Dispatcher"})
public class ResteasyDispatcher
extends HttpServletDispatcher {
    @In
    Application application;
    @Logger
    Log log;

    @Create
    public void onStartup() {
        this.log.debug((Object)"registering RESTEasy and JAX RS resources and providers", new Object[0]);
        ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();
        ResteasyProviderFactory.setInstance((ResteasyProviderFactory)providerFactory);
        this.setDispatcher((Dispatcher)new AsynchronousDispatcher(providerFactory));
        this.getDispatcher().setLanguageMappings(this.application.getLanguageMappings());
        this.getDispatcher().setMediaTypeMappings(this.application.getMediaTypeMappings());
        if (this.application.isUseBuiltinProviders()) {
            this.log.info((Object)"registering built-in RESTEasy providers", new Object[0]);
            RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        }
        for (Class<?> providerClass : this.application.getProviderClasses()) {
            Set<Component> seamComponents = this.application.getProviderClassComponent(providerClass);
            if (seamComponents != null) {
                for (Component seamComponent : seamComponents) {
                    if (ScopeType.STATELESS.equals((Object)seamComponent.getScope())) {
                        throw new RuntimeException("Registration of STATELESS Seam components as RESTEasy providers not implemented!");
                    }
                    if (!ScopeType.APPLICATION.equals((Object)seamComponent.getScope())) continue;
                    Object providerInstance = Component.getInstance((String)seamComponent.getName());
                    boolean isStringConverter = false;
                    for (Class componentIface : seamComponent.getBusinessInterfaces()) {
                        if (!StringConverter.class.isAssignableFrom(componentIface)) continue;
                        isStringConverter = true;
                        break;
                    }
                    if (isStringConverter) {
                        this.log.error((Object)"can't register Seam component as RESTEasy StringConverter, see: https://jira.jboss.org/jira/browse/JBSEAM-4020", new Object[0]);
                        continue;
                    }
                    providerFactory.registerProviderInstance(providerInstance);
                }
                continue;
            }
            if (StringConverter.class.isAssignableFrom(providerClass)) {
                this.log.debug((Object)("registering as custom RESTEasy string converter provider class: " + providerClass), new Object[0]);
                providerFactory.addStringConverter(providerClass);
                continue;
            }
            providerFactory.registerProvider(providerClass);
        }
        Registry registry = this.getDispatcher().getRegistry();
        for (final Class<?> resourceClass : this.application.getClasses()) {
            this.log.debug((Object)("registering JAX RS resource class: " + resourceClass), new Object[0]);
            Set<Component> components = this.application.getResourceClassComponent(resourceClass);
            if (components != null) {
                this.log.debug((Object)"registering all {0} components of {1}", new Object[]{components.size(), resourceClass});
                for (final Component seamComponent : components) {
                    ResourceFactory factory = new ResourceFactory(){

                        public Class<?> getScannableClass() {
                            return resourceClass;
                        }

                        public void registered(InjectorFactory factory) {
                            seamComponent.addInterceptor((Object)new ResteasyContextInjectionInterceptor((PropertyInjector)new PropertyInjectorImpl(this.getScannableClass(), ResteasyDispatcher.this.dispatcher.getProviderFactory())));
                        }

                        public Object createResource(HttpRequest request, HttpResponse response, InjectorFactory factory) {
                            Contexts.getEventContext().set("org.jboss.resteasy.spi.HttpRequest", (Object)request);
                            Contexts.getEventContext().set("org.jboss.resteasy.spi.HttpResponse", (Object)response);
                            return Component.getInstance((String)seamComponent.getName());
                        }

                        public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
                        }

                        public void unregistered() {
                        }
                    };
                    if (AbstractResource.class.isAssignableFrom(seamComponent.getBeanClass())) {
                        AbstractResource instance = (AbstractResource)seamComponent.newInstance();
                        String path = instance.getPath();
                        if (instance.getPath() != null) {
                            this.log.debug((Object)"registering resource {0} on path {1}", new Object[]{seamComponent.getName(), path});
                            registry.addResourceFactory(factory, path);
                            continue;
                        }
                        this.log.debug((Object)"registering resource {0}", new Object[]{seamComponent.getName()});
                        registry.addResourceFactory(factory);
                        continue;
                    }
                    this.log.debug((Object)"registering resource {0}", new Object[]{seamComponent.getName()});
                    registry.addResourceFactory(factory);
                }
                continue;
            }
            if (ResourceHome.class.equals(resourceClass) || ResourceQuery.class.equals(resourceClass)) continue;
            this.log.info((Object)"registering resource {0} with default JAX-RS lifecycle", new Object[]{resourceClass});
            registry.addResourceFactory((ResourceFactory)new POJOResourceFactory(resourceClass));
        }
    }
}

