/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.PathHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.resteasy.ResteasyDispatcher;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.web.AbstractResource;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.resteasy.resourceAdapter")
@BypassInterceptors
public class ResteasyResourceAdapter
extends AbstractResource {
    @Logger
    Log log;

    public String getResourcePath() {
        Application appConfig = (Application)((Object)Component.getInstance(Application.class));
        return appConfig.getResourcePathPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResource(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            this.log.debug((Object)"processing REST request", new Object[0]);
            ResteasyProviderFactory.pushContext(HttpServletRequest.class, (Object)request);
            ResteasyProviderFactory.pushContext(HttpServletResponse.class, (Object)response);
            ResteasyProviderFactory.pushContext(SecurityContext.class, (Object)new ServletSecurityContext(request));
            new ContextualHttpServletRequest(request){

                public void process() throws ServletException, IOException {
                    URI absolutePath;
                    HttpHeaders headers = ServletUtil.extractHttpHeaders((HttpServletRequest)request);
                    try {
                        URL absolute = new URL(request.getRequestURL().toString());
                        UriBuilderImpl builder = new UriBuilderImpl();
                        builder.scheme(absolute.getProtocol());
                        builder.host(absolute.getHost());
                        builder.port(absolute.getPort());
                        builder.path(absolute.getPath());
                        builder.replaceQuery(absolute.getQuery());
                        absolutePath = builder.build(new Object[0]);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                    String path = PathHelper.getEncodedPathInfo((String)absolutePath.getRawPath(), (String)request.getContextPath());
                    Application appConfig = (Application)((Object)Component.getInstance(Application.class));
                    if (appConfig.isStripSeamResourcePath()) {
                        ResteasyResourceAdapter.this.log.trace((Object)"removing SeamResourceServlet url-pattern and dispatcher prefix from request path", new Object[0]);
                        path = path.substring(path.indexOf(ResteasyResourceAdapter.this.getResourcePath()) + ResteasyResourceAdapter.this.getResourcePath().length());
                    }
                    ResteasyResourceAdapter.this.log.debug((Object)("final request path: " + path), new Object[0]);
                    List pathSegments = PathSegmentImpl.parseSegments((String)path);
                    UriInfoImpl uriInfo = new UriInfoImpl(absolutePath, path, request.getQueryString(), pathSegments);
                    ResteasyDispatcher dispatcher = (ResteasyDispatcher)((Object)Component.getInstance(ResteasyDispatcher.class));
                    HttpServletResponseWrapper theResponse = new HttpServletResponseWrapper(response, dispatcher.getDispatcher().getProviderFactory());
                    HttpServletInputMessage in = new HttpServletInputMessage(request, (HttpResponse)theResponse, headers, (UriInfo)uriInfo, request.getMethod().toUpperCase(), (SynchronousDispatcher)dispatcher.getDispatcher());
                    dispatcher.getDispatcher().invoke((HttpRequest)in, (HttpResponse)theResponse);
                }
            }.run();
        }
        finally {
            ResteasyProviderFactory.clearContextData();
            this.log.debug((Object)"completed processing of REST request", new Object[0]);
        }
    }
}

