/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.resteasy;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.JndiName;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.deployment.AnnotationDeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.AbstractResource;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.resteasy.ResourceHome;
import org.jboss.seam.resteasy.ResourceQuery;
import org.jboss.seam.resteasy.SeamResteasyProviderFactory;
import org.jboss.seam.resteasy.SeamResteasyResourceFactory;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Reflections;

@Name(value="org.jboss.seam.resteasy.bootstrap")
@Scope(value=ScopeType.APPLICATION)
@Startup
@AutoCreate
@Install(precedence=0, classDependencies={"org.jboss.resteasy.spi.ResteasyProviderFactory"})
public class ResteasyBootstrap {
    @Logger
    Log log;
    @In
    protected Application application;
    protected Dispatcher dispatcher;

    @Factory(value="org.jboss.seam.resteasy.dispatcher")
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Create
    public void init() {
        this.log.info((Object)"bootstrapping JAX-RS application", new Object[0]);
        SeamResteasyProviderFactory providerFactory = this.createProviderFactory();
        this.dispatcher = this.createDispatcher(providerFactory);
        this.initDispatcher();
        SeamResteasyProviderFactory.setInstance((ResteasyProviderFactory)new ThreadLocalResteasyProviderFactory((ResteasyProviderFactory)providerFactory));
        this.dispatcher.getDefaultContextObjects().put(Providers.class, providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Registry.class, this.dispatcher.getRegistry());
        this.dispatcher.getDefaultContextObjects().put(Dispatcher.class, this.dispatcher);
        Map contextDataMap = SeamResteasyProviderFactory.getContextDataMap();
        contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
        DeploymentStrategy deployment = (DeploymentStrategy)Component.getInstance((String)"deploymentStrategy");
        AnnotationDeploymentHandler handler = (AnnotationDeploymentHandler)deployment.getDeploymentHandlers().get("org.jboss.seam.deployment.AnnotationDeploymentHandler");
        Collection<Class<?>> providers = this.findProviders(handler);
        Collection<Class<?>> resources = this.findResources(handler);
        Collection<Component> seamComponents = this.findSeamComponents();
        this.registerProviders(seamComponents, providers);
        this.registerResources(seamComponents, resources);
    }

    protected SeamResteasyProviderFactory createProviderFactory() {
        return new SeamResteasyProviderFactory();
    }

    protected Dispatcher createDispatcher(SeamResteasyProviderFactory providerFactory) {
        return new SynchronousDispatcher((ResteasyProviderFactory)providerFactory);
    }

    protected void initDispatcher() {
        this.getDispatcher().setLanguageMappings(this.application.getLanguageMappings());
        this.getDispatcher().setMediaTypeMappings(this.application.getMediaTypeMappings());
    }

    protected Collection<Class<?>> findProviders(AnnotationDeploymentHandler handler) {
        return this.findTypes(handler, this.application.isScanProviders(), Provider.class.getName(), this.application.getProviderClassNames());
    }

    protected Collection<Class<?>> findResources(AnnotationDeploymentHandler handler) {
        return this.findTypes(handler, this.application.isScanResources(), Path.class.getName(), this.application.getResourceClassNames());
    }

    protected Collection<Class<?>> findTypes(AnnotationDeploymentHandler handler, boolean scanClasspathForAnnotations, String annotationFQName, Collection<String> includeTypeNames) {
        Collection annotatedTypes;
        HashSet types = new HashSet();
        if (scanClasspathForAnnotations && (annotatedTypes = (Collection)handler.getClassMap().get(annotationFQName)) != null) {
            types.addAll(annotatedTypes);
        }
        try {
            for (String s : new HashSet<String>(includeTypeNames)) {
                types.add(Reflections.classForName((String)s));
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)("error loading JAX-RS type: " + ex.getMessage()), (Throwable)ex, new Object[0]);
        }
        return types;
    }

    protected Collection<Component> findSeamComponents() {
        String[] applicationContextNames;
        this.log.debug((Object)"discovering all Seam components", new Object[0]);
        HashSet<Component> seamComponents = new HashSet<Component>();
        for (String applicationContextName : applicationContextNames = Contexts.getApplicationContext().getNames()) {
            if (!applicationContextName.endsWith(".component")) continue;
            Component seamComponent = (Component)Component.getInstance((String)applicationContextName, (ScopeType)ScopeType.APPLICATION);
            seamComponents.add(seamComponent);
        }
        return seamComponents;
    }

    protected void registerProviders(Collection<Component> seamComponents, Collection<Class<?>> providerClasses) {
        if (this.application.isUseBuiltinProviders()) {
            this.log.info((Object)"registering built-in RESTEasy providers", new Object[0]);
            RegisterBuiltin.register((ResteasyProviderFactory)this.getDispatcher().getProviderFactory());
        }
        HashSet handledProviders = new HashSet();
        for (Class<?> providerClass : providerClasses) {
            if (handledProviders.contains(providerClass) || providerClass.getName().startsWith("org.jboss.resteasy.plugins.providers") || providerClass.isInterface()) continue;
            if (StringConverter.class.isAssignableFrom(providerClass)) {
                this.log.debug((Object)"registering provider as RESTEasy StringConverter: {0}", new Object[]{providerClass});
                this.getDispatcher().getProviderFactory().addStringConverter(providerClass);
                continue;
            }
            this.log.debug((Object)"registering provider as plain JAX-RS type: {0}", new Object[]{providerClass});
            this.getDispatcher().getProviderFactory().registerProvider(providerClass);
        }
    }

    protected void registerResources(Collection<Component> seamComponents, Collection<Class<?>> resourceClasses) {
        HashSet<Class> handledResources = new HashSet<Class>();
        handledResources.add(ResourceHome.class);
        handledResources.add(ResourceQuery.class);
        for (Component component : seamComponents) {
            if (component.getBeanClass().equals(ResourceHome.class) || component.getBeanClass().equals(ResourceQuery.class)) {
                this.registerHomeQueryResources(component);
                continue;
            }
            Class resourceInterface = this.getAnnotatedInterface(Path.class, component);
            block0 : switch (component.getType()) {
                case STATELESS_SESSION_BEAN: {
                    if (resourceInterface == null) break;
                    this.registerInterfaceSeamComponentResource(component, resourceInterface);
                    break;
                }
                case STATEFUL_SESSION_BEAN: {
                    if (resourceInterface == null) break;
                    this.log.error((Object)("Not implemented: Stateful EJB Seam component resource: " + component), new Object[0]);
                    break;
                }
                case JAVA_BEAN: {
                    if (resourceInterface == null && !component.getBeanClass().isAnnotationPresent(Path.class)) break;
                    switch (component.getScope()) {
                        case EVENT: 
                        case APPLICATION: 
                        case STATELESS: 
                        case SESSION: {
                            if (resourceInterface != null) {
                                this.registerInterfaceSeamComponentResource(component, resourceInterface);
                                break block0;
                            }
                            if (!component.getBeanClass().isAnnotationPresent(Path.class)) break block0;
                            this.registerSeamComponentResource(component);
                            break block0;
                        }
                    }
                    throw new RuntimeException("Resource Seam component '" + component.getName() + "' must be scoped either " + "EVENT, APPLICATION, STATELESS, or SESSION");
                }
            }
            handledResources.add(component.getBeanClass());
            handledResources.addAll(component.getBusinessInterfaces());
        }
        for (Class clazz : resourceClasses) {
            if (handledResources.contains(clazz) || clazz.isInterface()) continue;
            if (clazz.isAnnotationPresent(EJB.STATELESS)) {
                this.registerStatelessEJBResource(clazz);
                continue;
            }
            if (clazz.isAnnotationPresent(EJB.STATEFUL)) {
                throw new RuntimeException("Only stateless EJBs can be JAX-RS resources, remove from configuration: " + clazz.getName());
            }
            this.registerPlainResource(clazz);
        }
    }

    protected void registerHomeQueryResources(Component seamComponent) {
        AbstractResource instance = (AbstractResource)seamComponent.newInstance();
        String path = instance.getPath();
        if (path != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.log.debug((Object)"registering resource, configured ResourceHome/Query on path {1}, as Seam component: {0}", new Object[]{seamComponent.getName(), path});
            SeamResteasyResourceFactory factory = new SeamResteasyResourceFactory(seamComponent.getBeanClass(), seamComponent, this.getDispatcher().getProviderFactory());
            this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)factory, path);
        } else {
            this.log.error((Object)"Unable to register {0} resource on null path, check components.xml", new Object[]{seamComponent.getName()});
        }
    }

    protected void registerSeamComponentResource(Component seamComponent) {
        this.log.debug((Object)"registering resource as Seam component: {0}", new Object[]{seamComponent.getName()});
        SeamResteasyResourceFactory factory = new SeamResteasyResourceFactory(seamComponent.getBeanClass(), seamComponent, this.getDispatcher().getProviderFactory());
        this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)factory);
    }

    protected void registerInterfaceSeamComponentResource(Component seamComponent, Class resourceInterface) {
        this.log.debug((Object)"registering resource, annotated interface {1}, as Seam component: {0}", new Object[]{seamComponent.getName(), resourceInterface.getName()});
        SeamResteasyResourceFactory factory = new SeamResteasyResourceFactory(resourceInterface, seamComponent, this.getDispatcher().getProviderFactory());
        this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)factory);
    }

    protected void registerStatelessEJBResource(Class ejbImplementationClass) {
        String jndiName = this.getJndiName(ejbImplementationClass);
        this.log.debug((Object)"registering resource, stateless EJB implementation {1}, as RESTEasy JNDI resource name: {0}", new Object[]{jndiName, ejbImplementationClass.getName()});
        this.getDispatcher().getRegistry().addJndiResource(jndiName);
    }

    protected void registerPlainResource(Class plainResourceClass) {
        this.log.debug((Object)"registering resource, event-scoped JAX-RS lifecycle: {0}", new Object[]{plainResourceClass.getName()});
        this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)new POJOResourceFactory(plainResourceClass));
    }

    protected void registerSeamComponentProvider(Component seamComponent) {
        this.log.debug((Object)"registering provider as Seam component: {0}", new Object[]{seamComponent.getName()});
        this.getDispatcher().getProviderFactory().registerProviderInstance(Component.getInstance((String)seamComponent.getName()));
    }

    protected Class getAnnotatedInterface(Class<? extends Annotation> annotation, Component seamComponent) {
        Class resourceInterface = null;
        for (Class anInterface : seamComponent.getBusinessInterfaces()) {
            if (!anInterface.isAnnotationPresent(annotation)) continue;
            if (resourceInterface != null) {
                throw new IllegalStateException("Only one business interface can be annotated " + annotation + ": " + seamComponent);
            }
            resourceInterface = anInterface;
        }
        return resourceInterface;
    }

    protected String getJndiName(Class<?> beanClass) {
        if (beanClass.isAnnotationPresent(JndiName.class)) {
            return beanClass.getAnnotation(JndiName.class).value();
        }
        String jndiPattern = Init.instance().getJndiPattern();
        if (jndiPattern == null) {
            throw new IllegalArgumentException("You must specify org.jboss.seam.core.init.jndiPattern or use @JndiName: " + beanClass.getName());
        }
        return jndiPattern.replace("#{ejbName}", Seam.getEjbName(beanClass));
    }
}

