/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBuilder {
    private static final String URL_ENCODING = "UTF-8";
    private String url;
    private String fragment;
    private String characterEncoding;
    private boolean urlEncodeParameters = true;
    private Map<String, String> parameters;

    protected UrlBuilder(String fragment, String characterEncoding) {
        this.fragment = fragment;
        this.parameters = new HashMap<String, String>();
        this.characterEncoding = characterEncoding;
    }

    public UrlBuilder(String fragment, String characterEncoding, boolean urlEncodeParameters) {
        this(fragment, characterEncoding);
        this.urlEncodeParameters = urlEncodeParameters;
    }

    public UrlBuilder(String url, String fragment, String characterEncoding) {
        this(fragment, characterEncoding);
        this.setUrl(url);
    }

    public UrlBuilder(String url, String fragment, String characterEncoding, boolean urlEncodeParameters) {
        this(url, fragment, characterEncoding);
        this.urlEncodeParameters = urlEncodeParameters;
    }

    protected void setUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url must not be null");
        }
        this.url = url;
    }

    protected String urlEncode(String value) throws UnsupportedEncodingException {
        return this.characterEncoding == null ? URLEncoder.encode(value, URL_ENCODING) : URLEncoder.encode(value, this.characterEncoding);
    }

    protected String getFragment() {
        if (this.fragment != null && !"".equals(this.fragment)) {
            return "#" + this.fragment;
        }
        return "";
    }

    public String getEncodedUrl() {
        String params = this.getParametersAsString();
        if (!"".equals(params) && !this.url.contains("?")) {
            params = "?" + params.substring(1);
        }
        return this.url + params + this.getFragment();
    }

    protected String getParametersAsString() {
        String params = "";
        for (String key : this.parameters.keySet()) {
            params = params + "&" + key + "=" + this.parameters.get(key);
        }
        return params;
    }

    protected Map<String, String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name, String value) throws UnsupportedEncodingException {
        this.parameters.put(name, this.urlEncodeParameters ? this.urlEncode(value) : value);
    }

    public void addParameter(UIParameter parameter) throws UnsupportedEncodingException {
        String value = parameter.getValue() == null ? "" : parameter.getValue().toString();
        String name = parameter.getName();
        this.addParameter(name, value);
    }
}

