/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ValueHolder;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.jboss.seam.framework.Query;
import org.jboss.seam.ui.converter.ConverterChain;
import org.jboss.seam.ui.converter.NoSelectionConverter;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UISelectItems
extends javax.faces.component.UISelectItems {
    private List<SelectItem> selectItems;
    private Object originalValue;
    private static final String NO_SELECTION_VALUE = null;
    private String label;

    public String getLabel() {
        Object object;
        ValueExpression ve = this.getValueExpression("label");
        if (ve != null && (object = ve.getValue(this.getFacesContext().getELContext())) != null) {
            return object.toString();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public abstract void setHideNoSelectionLabel(Boolean var1);

    public abstract Boolean getHideNoSelectionLabel();

    public abstract String getNoSelectionLabel();

    public abstract void setNoSelectionLabel(String var1);

    public abstract String getVar();

    public abstract void setVar(String var1);

    public abstract Boolean getDisabled();

    public abstract void setDisabled(Boolean var1);

    public abstract Boolean getEscape();

    public abstract void setEscape(Boolean var1);

    public abstract Object getItemValue();

    public abstract void setItemValue(Object var1);

    public Object getValue() {
        ArrayList<SelectItem> temporarySelectItems = new ArrayList<SelectItem>();
        SelectItem noSelectionLabel = this.noSelectionLabel();
        if (noSelectionLabel != null) {
            temporarySelectItems.add(noSelectionLabel);
        }
        if (this.selectItems == null || this.originalValue == null || !this.originalValue.equals(super.getValue())) {
            this.originalValue = super.getValue();
            this.selectItems = new ArrayList<SelectItem>();
            if (this.originalValue instanceof Iterable) {
                this.selectItems.addAll(this.asSelectItems((Iterable)this.originalValue));
            } else if (this.originalValue instanceof DataModel && ((DataModel)this.originalValue).getWrappedData() instanceof Iterable) {
                this.selectItems.addAll(this.asSelectItems((Iterable)((DataModel)this.originalValue).getWrappedData()));
            } else if (this.originalValue instanceof Query) {
                this.selectItems.addAll(this.asSelectItems(((Query)this.originalValue).getResultList()));
            } else if (this.originalValue != null && this.originalValue.getClass().isArray()) {
                this.selectItems.addAll(this.asSelectItems(UISelectItems.arrayAsList(this.originalValue)));
            } else if (temporarySelectItems.size() == 0) {
                return this.originalValue;
            }
        }
        temporarySelectItems.addAll(this.selectItems);
        return temporarySelectItems;
    }

    private List<SelectItem> asSelectItems(Iterable iterable) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (Object o : iterable) {
            selectItems.add(new ContextualSelectItem(o){

                protected Boolean getSelectItemDisabled() {
                    Boolean disabled = UISelectItems.this.getDisabled();
                    return disabled == null ? false : disabled;
                }

                protected Boolean getSelectItemEscape() {
                    Boolean escape = UISelectItems.this.getEscape();
                    return escape == null ? true : escape;
                }

                protected String getSelectItemLabel() {
                    return Strings.emptyIfNull((String)UISelectItems.this.getLabel());
                }

                protected Object getSelectItemValue() {
                    Object value = UISelectItems.this.getItemValue();
                    return value == null ? this.getVarValue() : value;
                }
            }.create());
        }
        return selectItems;
    }

    private SelectItem noSelectionLabel() {
        if (this.isShowNoSelectionLabel()) {
            NoSelectionConverter noSelectionConverter;
            NullableSelectItem s = new NullableSelectItem(NO_SELECTION_VALUE, this.getNoSelectionLabel());
            ConverterChain converterChain = new ConverterChain(this.getParent());
            if (!converterChain.containsConverterType(noSelectionConverter = new NoSelectionConverter())) {
                converterChain.addConverterToChain(noSelectionConverter, 0);
            }
            return s;
        }
        return null;
    }

    private boolean isShowNoSelectionLabel() {
        ValueExpression vb = this.getValueExpression("noSelectionLabel");
        String noSelectionLabel = this.getNoSelectionLabel();
        Boolean hideNoSelectionLabel = this.getHideNoSelectionLabel();
        Object parentValue = this.getParentValue();
        if (!(noSelectionLabel == null || vb != null || hideNoSelectionLabel.booleanValue() && parentValue != null)) {
            return true;
        }
        return noSelectionLabel != null && !"".equals(noSelectionLabel) && (hideNoSelectionLabel == false || parentValue == null);
    }

    private Object getParentValue() {
        if (this.getParent() instanceof ValueHolder) {
            ValueHolder parent = (ValueHolder)this.getParent();
            return parent.getValue();
        }
        return null;
    }

    private static List arrayAsList(Object array) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < Array.getLength(array)) {
                list.add(Array.get(array, i));
                ++i;
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }

    private abstract class ContextualSelectItem {
        private Object varValue;

        public ContextualSelectItem(Object varValue) {
            if (varValue == null) {
                throw new FacesException("var attribute must be set");
            }
            this.varValue = varValue;
        }

        protected Object getVarValue() {
            return this.varValue;
        }

        private void setup() {
            UISelectItems.this.getFacesContext().getExternalContext().getRequestMap().put(UISelectItems.this.getVar(), this.varValue);
        }

        private void cleanup() {
            UISelectItems.this.getFacesContext().getExternalContext().getRequestMap().remove(UISelectItems.this.getVar());
        }

        protected abstract Object getSelectItemValue();

        protected abstract String getSelectItemLabel();

        protected abstract Boolean getSelectItemDisabled();

        protected abstract Boolean getSelectItemEscape();

        protected SelectItem create() {
            try {
                this.setup();
                SelectItem selectItem = new SelectItem(this.getSelectItemValue(), this.getSelectItemLabel(), "", this.getSelectItemDisabled().booleanValue(), this.getSelectItemEscape().booleanValue());
                return selectItem;
            }
            finally {
                this.cleanup();
            }
        }
    }

    private class NullableSelectItem
    extends SelectItem {
        private Object value;

        private NullableSelectItem(Object value, String label) {
            super.setLabel(label);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

