/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.facelet;

import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.compiler.TagLibraryConfig;
import com.sun.facelets.tag.TagDecorator;
import com.sun.facelets.tag.TagLibrary;
import com.sun.facelets.util.ReflectionUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Name(value="org.jboss.seam.ui.facelet.faceletCompiler")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@AutoCreate
@Install(value=true, precedence=0, classDependencies={"com.sun.facelets.Facelet"})
public class FaceletCompiler {
    private LogProvider log = Logging.getLogProvider(FaceletCompiler.class);
    private Compiler compiler;

    @Create
    public void create() {
        this.compiler = new SAXCompiler();
        this.initializeCompiler(this.compiler);
    }

    protected void initializeCompiler(Compiler compiler) {
        String skipParameters;
        String decoratorParameter;
        int i;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        String libraryParameter = externalContext.getInitParameter("facelets.LIBRARIES");
        if (libraryParameter != null) {
            libraryParameter = libraryParameter.trim();
            String[] libraries = libraryParameter.split(";");
            i = 0;
            while (i < libraries.length) {
                try {
                    URL src = externalContext.getResource(libraries[i].trim());
                    if (src == null) {
                        throw new FileNotFoundException(libraries[i]);
                    }
                    TagLibrary libraryObject = TagLibraryConfig.create((URL)src);
                    compiler.addTagLibrary(libraryObject);
                    this.log.trace((Object)("Successfully Loaded Library: " + libraries[i]));
                }
                catch (IOException e) {
                    this.log.error((Object)("Error Loading Library: " + libraries[i]), (Throwable)e);
                }
                ++i;
            }
        }
        if ((decoratorParameter = externalContext.getInitParameter("facelets.DECORATORS")) != null) {
            decoratorParameter = decoratorParameter.trim();
            String[] decorators = decoratorParameter.split(";");
            i = 0;
            while (i < decorators.length) {
                try {
                    TagDecorator decoratorObject = (TagDecorator)ReflectionUtil.forName((String)decorators[i]).newInstance();
                    compiler.addTagDecorator(decoratorObject);
                    this.log.trace((Object)("Successfully Loaded Decorator: " + decorators[i]));
                }
                catch (Exception e) {
                    this.log.error((Object)("Error Loading Decorator: " + decorators[i]), (Throwable)e);
                }
                ++i;
            }
        }
        if ((skipParameters = externalContext.getInitParameter("facelets.SKIP_COMMENTS")) != null && "true".equals(skipParameters)) {
            compiler.setTrimmingComments(true);
        }
    }

    @Unwrap
    public Compiler unwrap() {
        return this.compiler;
    }

    public static Compiler instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        return (Compiler)Component.getInstance(FaceletCompiler.class, (ScopeType)ScopeType.APPLICATION);
    }
}

