/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.facelet;

import com.sun.facelets.Facelet;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.jsf.DelegatingFacesContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mock.MockHttpServletRequest;
import org.jboss.seam.mock.MockHttpServletResponse;
import org.jboss.seam.ui.facelet.FaceletCompiler;
import org.jboss.seam.ui.facelet.HttpSessionManager;
import org.jboss.seam.ui.facelet.RendererFacesContextFactory;
import org.jboss.seam.ui.util.JSF;

public class RendererRequest {
    private static final LogProvider log = Logging.getLogProvider(RendererRequest.class);
    private FacesContext originalFacesContext;
    private FacesContext facesContext;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private StringWriter writer;
    private String viewId;
    private ClassLoader originalClassLoader;

    public RendererRequest(String viewId) {
        this.viewId = viewId;
    }

    private void init() {
        this.request = FacesContext.getCurrentInstance() != null ? new MockHttpServletRequest(HttpSessionManager.instance(), FacesContext.getCurrentInstance().getExternalContext()) : new MockHttpServletRequest(HttpSessionManager.instance());
        this.response = new MockHttpServletResponse();
        this.setContextClassLoader();
        this.originalFacesContext = FacesContext.getCurrentInstance();
        this.facesContext = RendererFacesContextFactory.instance().getFacesContext((ServletRequest)this.request, (ServletResponse)this.response);
        DelegatingFacesContext.setCurrentInstance((FacesContext)this.facesContext);
        UIViewRoot newRoot = this.facesContext.getApplication().getViewHandler().createView(this.facesContext, this.viewId);
        this.facesContext.setViewRoot(newRoot);
        this.writer = new StringWriter();
        this.facesContext.setResponseWriter(this.facesContext.getRenderKit().createResponseWriter((Writer)this.writer, null, null));
    }

    private void cleanup() {
        this.facesContext.release();
        DelegatingFacesContext.setCurrentInstance((FacesContext)this.originalFacesContext);
        this.originalFacesContext = null;
        this.facesContext = null;
        this.request = null;
        this.response = null;
    }

    protected void setContextClassLoader() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        ServletContext ctx = this.request.getSession().getServletContext();
        WeakReference ref = (WeakReference)ctx.getAttribute("seam.context.classLoader");
        if (ref == null || ref.get() == null) {
            log.warn((Object)"Failed to bootstrap context classloader. Facelets may not work properly from MDBs");
        } else {
            Thread.currentThread().setContextClassLoader((ClassLoader)ref.get());
        }
    }

    protected void resetContextClassLoader() {
        if (this.originalClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
            this.originalClassLoader = null;
        }
    }

    public void run() throws IOException {
        try {
            this.init();
            this.renderFacelet(this.facesContext, this.faceletForViewId(this.viewId));
        }
        finally {
            this.cleanup();
            this.resetContextClassLoader();
        }
    }

    public String getOutput() {
        return this.writer.getBuffer().toString();
    }

    protected Facelet faceletForViewId(String viewId) throws IOException {
        URL url = ResourceLoader.instance().getResource(viewId);
        if (url == null) {
            throw new IllegalArgumentException("resource doesn't exist: " + viewId);
        }
        return new DefaultFaceletFactory(FaceletCompiler.instance(), (ResourceResolver)new DefaultResourceResolver()).getFacelet(url);
    }

    protected void renderFacelet(FacesContext facesContext, Facelet facelet) throws IOException {
        UIViewRoot root = facesContext.getViewRoot();
        facelet.apply(facesContext, (UIComponent)root);
        JSF.renderChildren(facesContext, (UIComponent)root);
    }
}

