/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.renderkit;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpSession;
import org.jboss.seam.ui.RenderStampStore;
import org.jboss.seam.ui.UnauthorizedCommandException;
import org.jboss.seam.ui.component.UIToken;
import org.jboss.seam.ui.util.cdk.RendererBase;
import org.jboss.seam.util.Base64;
import org.jboss.seam.util.RandomStringUtils;

public class TokenRendererBase
extends RendererBase {
    public static final String FORM_SIGNATURE_PARAM = "javax.faces.FormSignature";
    public static final String RENDER_STAMP_ATTR = "javax.faces.RenderStamp";
    private static final String COOKIE_CHECK_SCRIPT_KEY = "org.jboss.seam.ui.COOKIE_CHECK_SCRIPT";

    protected Class getComponentClass() {
        return UIToken.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        UIToken token = (UIToken)component;
        UIForm form = token.getParentForm();
        if (context.getRenderKit().getResponseStateManager().isPostback(context) && form.isSubmitted()) {
            String clientToken = token.getClientUid();
            String viewId = context.getViewRoot().getViewId();
            if (clientToken == null) {
                throw new UnauthorizedCommandException(viewId, "No client identifier provided");
            }
            String requestedViewSig = (String)context.getExternalContext().getRequestParameterMap().get(FORM_SIGNATURE_PARAM);
            if (requestedViewSig == null) {
                throw new UnauthorizedCommandException(viewId, "No form signature provided");
            }
            if (!requestedViewSig.equals(this.generateViewSignature(context, form, !token.isAllowMultiplePosts(), token.isRequireSession(), clientToken))) {
                throw new UnauthorizedCommandException(viewId, "Form signature invalid");
            }
            RenderStampStore store = RenderStampStore.instance();
            if (store != null) {
                store.removeStamp(String.valueOf(form.getAttributes().get(RENDER_STAMP_ATTR)));
            }
            form.getAttributes().remove(RENDER_STAMP_ATTR);
        }
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIToken token = (UIToken)component;
        UIForm form = token.getParentForm();
        if (form == null) {
            throw new IllegalStateException("UIToken must be inside a UIForm.");
        }
        String renderStamp = RandomStringUtils.randomAlphanumeric((int)50);
        RenderStampStore store = RenderStampStore.instance();
        if (store != null) {
            renderStamp = store.storeStamp(renderStamp);
        }
        this.writeCookieCheckScript(context, writer, token);
        token.getClientUidSelector().seed();
        form.getAttributes().put(RENDER_STAMP_ATTR, renderStamp);
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("name", (Object)FORM_SIGNATURE_PARAM, "name");
        writer.writeAttribute("value", (Object)this.generateViewSignature(context, form, !token.isAllowMultiplePosts(), token.isRequireSession(), token.getClientUidSelector().getClientUid()), "value");
        writer.endElement("input");
    }

    private void writeCookieCheckScript(FacesContext context, ResponseWriter writer, UIToken token) throws IOException {
        if (!token.getClientUidSelector().isSet() && token.isEnableCookieNotice() && !context.getExternalContext().getRequestMap().containsKey(COOKIE_CHECK_SCRIPT_KEY)) {
            writer.startElement("script", (UIComponent)token);
            writer.writeAttribute("type", (Object)"text/javascript", "type");
            writer.write("if (!document.cookie) { alert('This website uses a security measure that requires cookies to be enabled in your browser. Since you have cookies disabled, you will not be permitted to submit a form.'); }");
            writer.endElement("script");
            context.getExternalContext().getRequestMap().put(COOKIE_CHECK_SCRIPT_KEY, true);
        }
    }

    private String generateViewSignature(FacesContext context, UIForm form, boolean useRenderStamp, boolean useSessionId, String saltPhrase) {
        String rawViewSignature = String.valueOf(context.getExternalContext().getRequestContextPath()) + "," + context.getViewRoot().getViewId() + "," + form.getClientId(context);
        if (useRenderStamp) {
            String renderStamp = form.getAttributes().get(RENDER_STAMP_ATTR).toString();
            RenderStampStore store = RenderStampStore.instance();
            if (store != null) {
                renderStamp = store.getStamp(renderStamp);
            }
            rawViewSignature = String.valueOf(rawViewSignature) + "," + renderStamp;
        }
        if (useSessionId) {
            rawViewSignature = String.valueOf(rawViewSignature) + "," + ((HttpSession)context.getExternalContext().getSession(true)).getId();
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(saltPhrase.getBytes());
            byte[] salt = digest.digest();
            digest.reset();
            digest.update(rawViewSignature.getBytes());
            digest.update(salt);
            byte[] raw = digest.digest();
            return Base64.encodeBytes((byte[])raw);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

