/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.PersistenceContexts;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.core.conversation")
@Install(precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class Conversation
implements Serializable {
    private static final long serialVersionUID = -6131304128727444876L;
    private Integer timeout;
    String description;
    String viewId;

    public Integer getTimeout() {
        return this.timeout == null ? Manager.instance().getCurrentConversationTimeout() : this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getId() {
        return Manager.instance().getCurrentConversationId();
    }

    public String getDescription() {
        return this.description == null ? Manager.instance().getCurrentConversationDescription() : this.description;
    }

    public String getViewId() {
        return this.viewId == null ? Manager.instance().getCurrentConversationViewId() : this.viewId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setViewId(String outcome) {
        this.viewId = outcome;
    }

    public static Conversation instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (Conversation)Component.getInstance(Conversation.class, ScopeType.CONVERSATION);
    }

    void flush() {
        if (!Manager.instance().isLongRunningConversation()) {
            throw new IllegalStateException("only long-running conversation outcomes are switchable");
        }
        ConversationEntry entry = Manager.instance().getCurrentConversationEntry();
        if (this.viewId != null) {
            entry.setViewId(this.viewId);
        }
        if (this.description != null) {
            entry.setDescription(this.description);
        }
        if (this.timeout != null) {
            entry.setTimeout(this.timeout);
        }
        this.description = null;
        this.viewId = null;
        this.timeout = null;
    }

    public boolean redirect() {
        Manager manager = Manager.instance();
        String viewId = manager.getCurrentConversationViewId();
        return this.redirect(manager, viewId);
    }

    private boolean redirect(Manager manager, String viewId) {
        if (viewId == null) {
            return false;
        }
        manager.redirect(viewId);
        return true;
    }

    public boolean endAndRedirect() {
        this.end();
        Manager manager = Manager.instance();
        String viewId = manager.getParentConversationViewId();
        return this.redirect(manager, viewId);
    }

    public void leave() {
        Manager.instance().leaveConversation();
    }

    public boolean begin() {
        if (Manager.instance().isLongRunningOrNestedConversation()) {
            return false;
        }
        this.reallyBegin();
        return true;
    }

    private void reallyBegin() {
        Manager.instance().beginConversation(Seam.getComponentName(Conversation.class));
    }

    public void beginNested() {
        if (!Manager.instance().isLongRunningConversation()) {
            throw new IllegalStateException("beginNested() called with no long-running conversation");
        }
        Manager.instance().beginNestedConversation(Seam.getComponentName(Conversation.class));
    }

    public boolean begin(boolean join, boolean nested) {
        boolean longRunningConversation = Manager.instance().isLongRunningOrNestedConversation();
        if (!join && !nested && longRunningConversation) {
            throw new IllegalStateException("begin() called from long-running conversation, try join=true");
        }
        if (!longRunningConversation) {
            this.reallyBegin();
            return true;
        }
        if (nested) {
            this.beginNested();
            return true;
        }
        return false;
    }

    public void beginPageflow(String pageflowName) {
        Pageflow.instance().begin(pageflowName);
    }

    public void end() {
        Manager.instance().endConversation(false);
    }

    public void endBeforeRedirect() {
        Manager.instance().endConversation(true);
    }

    public boolean isLongRunning() {
        return Manager.instance().isReallyLongRunningConversation();
    }

    public boolean isNested() {
        return Manager.instance().isNestedConversation();
    }

    public String getParentId() {
        return Manager.instance().getParentConversationId();
    }

    public String getRootId() {
        return Manager.instance().getRootConversationId();
    }

    public void pop() {
        String parentId = this.getParentId();
        if (parentId != null) {
            Manager.instance().switchConversation(parentId);
        }
    }

    public boolean redirectToParent() {
        this.pop();
        return this.redirect();
    }

    public void root() {
        String rootId = this.getRootId();
        if (rootId != null) {
            Manager.instance().switchConversation(rootId);
        }
    }

    public boolean redirectToRoot() {
        this.root();
        return this.redirect();
    }

    public void changeFlushMode(FlushModeType flushMode) {
        PersistenceContexts.instance().changeFlushMode(flushMode);
    }
}

