/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.interceptor.Interceptors;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.timer.Duration;
import org.jboss.seam.annotations.timer.Expiration;
import org.jboss.seam.annotations.timer.IntervalDuration;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.BusinessProcess;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.LocalDispatcher;
import org.jboss.seam.ejb.SeamInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.util.Reflections;

@Stateless
@Name(value="org.jboss.seam.core.dispatcher")
@Interceptors(value={SeamInterceptor.class})
@Install(value=false, precedence=0)
public class Dispatcher
implements LocalDispatcher {
    public static final String EXECUTING_ASYNCHRONOUS_CALL = "org.jboss.seam.core.executingAsynchronousCall";
    @Resource
    TimerService timerService;

    @PostConstruct
    public void postConstruct() {
    }

    @Timeout
    public void dispatch(Timer timer) {
        ((Asynchronous)timer.getInfo()).execute(timer);
    }

    public Timer scheduleEvent(String type, Long duration, Date expiration, Long intervalDuration, Object ... parameters) {
        return this.schedule(duration, expiration, intervalDuration, new AsynchronousEvent(type, parameters));
    }

    public Timer scheduleInvocation(InvocationContext invocation, Component component) {
        Long duration = 0L;
        Date expiration = null;
        Long intervalDuration = null;
        Annotation[][] parameterAnnotations = invocation.getMethod().getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                if (annotation.annotationType().equals(Duration.class)) {
                    duration = (Long)invocation.getParameters()[i];
                    continue;
                }
                if (annotation.annotationType().equals(IntervalDuration.class)) {
                    intervalDuration = (Long)invocation.getParameters()[i];
                    continue;
                }
                if (!annotation.annotationType().equals(Expiration.class)) continue;
                expiration = (Date)invocation.getParameters()[i];
            }
        }
        AsynchronousInvocation asynchronousInvocation = new AsynchronousInvocation(invocation.getMethod(), component.getName(), invocation.getParameters());
        return this.schedule(duration, expiration, intervalDuration, asynchronousInvocation);
    }

    private Timer schedule(Long duration, Date expiration, Long intervalDuration, Asynchronous asynchronous) {
        if (intervalDuration != null) {
            if (expiration != null) {
                return new TimerProxy(this.timerService.createTimer(expiration, intervalDuration.longValue(), (Serializable)asynchronous));
            }
            return new TimerProxy(this.timerService.createTimer(duration.longValue(), intervalDuration.longValue(), (Serializable)asynchronous));
        }
        if (expiration != null) {
            return new TimerProxy(this.timerService.createTimer(expiration, (Serializable)asynchronous));
        }
        return new TimerProxy(this.timerService.createTimer(duration.longValue(), (Serializable)asynchronous));
    }

    public static LocalDispatcher instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("no application context active");
        }
        return (LocalDispatcher)Component.getInstance(Dispatcher.class);
    }

    public Object call(Callable task) {
        try {
            return task.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class TimerHandleProxy
    implements TimerHandle,
    Serializable {
        private static final long serialVersionUID = 6913362944260154627L;
        TimerHandle handle;

        public TimerHandleProxy(TimerHandle handle) {
            this.handle = handle;
        }

        private Object callInContext(Callable callable) {
            return Dispatcher.instance().call(callable);
        }

        public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            Timer timer = (Timer)this.callInContext(new Callable(){

                public Object call() {
                    return TimerHandleProxy.this.handle.getTimer();
                }
            });
            return new TimerProxy(timer);
        }
    }

    static class TimerProxy
    implements Timer {
        Timer timer;

        public TimerProxy(Timer timer) throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            this.timer = timer;
        }

        private Object callInContext(Callable callable) {
            return Dispatcher.instance().call(callable);
        }

        public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            this.callInContext(new Callable(){

                public Object call() {
                    TimerProxy.this.timer.cancel();
                    return null;
                }
            });
        }

        public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            TimerHandle handle = (TimerHandle)this.callInContext(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getHandle();
                }
            });
            return new TimerHandleProxy(handle);
        }

        public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            return (Serializable)this.callInContext(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getInfo();
                }
            });
        }

        public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            return (Date)this.callInContext(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getNextTimeout();
                }
            });
        }

        public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            return (Long)this.callInContext(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getTimeRemaining();
                }
            });
        }
    }

    static class AsynchronousEvent
    extends Asynchronous {
        static final long serialVersionUID = 2074586442931427819L;
        private String type;
        private Object[] parameters;

        public AsynchronousEvent(String type, Object[] parameters) {
            this.type = type;
            this.parameters = parameters;
        }

        public void call() {
            Events.instance().raiseEvent(this.type, this.parameters);
        }
    }

    static class AsynchronousInvocation
    extends Asynchronous {
        static final long serialVersionUID = 7426196491669891310L;
        private String methodName;
        private Class[] argTypes;
        private Object[] args;
        private String componentName;

        public AsynchronousInvocation(Method method, String componentName, Object[] args) {
            this.methodName = method.getName();
            this.argTypes = method.getParameterTypes();
            this.args = args == null ? new Object[]{} : args;
            this.componentName = componentName;
        }

        protected void call() {
            Method method;
            Object target = Component.getInstance(this.componentName);
            try {
                method = target.getClass().getMethod(this.methodName, this.argTypes);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalStateException(nsme);
            }
            Reflections.invokeAndWrap(method, target, this.args);
        }
    }

    public static abstract class Asynchronous
    implements Serializable {
        static final long serialVersionUID = -551286304424595765L;
        private Long processId;
        private Long taskId;

        protected Asynchronous() {
            if (Init.instance().isJbpmInstalled()) {
                BusinessProcess businessProcess = BusinessProcess.instance();
                this.processId = businessProcess.getProcessId();
                this.taskId = BusinessProcess.instance().getTaskId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Timer timer) {
            Lifecycle.beginCall();
            Contexts.getEventContext().set(Dispatcher.EXECUTING_ASYNCHRONOUS_CALL, true);
            try {
                if (this.taskId != null) {
                    BusinessProcess.instance().resumeTask(this.taskId);
                } else if (this.processId != null) {
                    BusinessProcess.instance().resumeProcess(this.processId);
                }
                Contexts.getEventContext().set("timer", timer);
                this.call();
            }
            finally {
                Contexts.getEventContext().remove(Dispatcher.EXECUTING_ASYNCHRONOUS_CALL);
                Lifecycle.endCall();
            }
        }

        protected abstract void call();
    }
}

