/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import org.jboss.ejb3.embedded.EJB3StandaloneBootstrap;
import org.jboss.ejb3.embedded.EJB3StandaloneDeployer;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Startup
@Name(value="org.jboss.seam.core.ejb")
@Install(value=false, precedence=0)
public class Ejb {
    private static final LogProvider log = Logging.getLogProvider(Ejb.class);
    private EJB3StandaloneDeployer deployer;
    private boolean started;

    @Create
    public void startup() throws Exception {
        log.info("starting the embedded EJB container");
        EJB3StandaloneBootstrap.boot(null);
        this.deploy("META-INF/jboss-beans.xml");
        this.deploy("jboss-beans.xml");
        this.deployer = EJB3StandaloneBootstrap.createDeployer();
        this.deployer.getArchivesByResource().add("seam.properties");
        this.deployer.getArchivesByResource().add("META-INF/seam.properties");
        this.deployer.getArchivesByResource().add("META-INF/components.xml");
        this.deployer.setJndiProperties(Naming.getInitialContextProperties());
        this.deployer.create();
        this.deployer.start();
        this.started = true;
    }

    private void deploy(String name) {
        if (Thread.currentThread().getContextClassLoader().getResource(name) != null) {
            EJB3StandaloneBootstrap.deployXmlResource((String)name);
        }
    }

    @Destroy
    public void shutdown() throws Exception {
        if (this.started) {
            log.info("stopping the embedded EJB container");
            this.deployer.stop();
            this.deployer.destroy();
            this.deployer = null;
        }
        EJB3StandaloneBootstrap.shutdown();
    }
}

