/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.exceptions.AnnotationErrorHandler;
import org.jboss.seam.exceptions.AnnotationRedirectHandler;
import org.jboss.seam.exceptions.AnnotationRenderHandler;
import org.jboss.seam.exceptions.ConfigErrorHandler;
import org.jboss.seam.exceptions.ConfigRedirectHandler;
import org.jboss.seam.exceptions.ConfigRenderHandler;
import org.jboss.seam.exceptions.DebugPageHandler;
import org.jboss.seam.exceptions.ExceptionHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Install(precedence=0)
@Name(value="org.jboss.seam.core.exceptions")
public class Exceptions {
    public static final LogProvider log = Logging.getLogProvider(Exceptions.class);
    private List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();

    public Object handle(Exception e) throws Exception {
        for (ExceptionHandler eh : this.exceptionHandlers) {
            if (!eh.isHandler(e)) continue;
            return eh.handle(e);
        }
        throw e;
    }

    @Create
    public void initialize() throws Exception {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/exceptions.xml");
        ExceptionHandler anyhandler = null;
        if (stream == null) {
            log.info("no exceptions.xml file found");
        } else {
            log.info("reading exceptions.xml");
            List elements = XML.getRootElement(stream).elements("exception");
            for (Element exception : elements) {
                String className = exception.attributeValue("class");
                if (className == null) {
                    anyhandler = this.createHandler(exception, Exception.class);
                    continue;
                }
                ExceptionHandler handler = this.createHandler(exception, Reflections.classForName(className));
                if (handler == null) continue;
                this.exceptionHandlers.add(handler);
            }
        }
        this.exceptionHandlers.add(new AnnotationRenderHandler());
        this.exceptionHandlers.add(new AnnotationRedirectHandler());
        this.exceptionHandlers.add(new AnnotationErrorHandler());
        if (Init.instance().isDebug()) {
            this.exceptionHandlers.add(new DebugPageHandler());
        }
        if (anyhandler != null) {
            this.exceptionHandlers.add(anyhandler);
        }
    }

    private ExceptionHandler createHandler(Element exception, Class clazz) {
        boolean endConversation = exception.elementIterator("end-conversation").hasNext();
        boolean rollback = exception.elementIterator("rollback").hasNext();
        Element render = exception.element("render");
        if (render != null) {
            String viewId = render.attributeValue("view-id");
            String message = render.getTextTrim();
            return new ConfigRenderHandler(message, viewId, clazz, rollback, endConversation);
        }
        Element redirect = exception.element("redirect");
        if (redirect != null) {
            String viewId = redirect.attributeValue("view-id");
            String message = redirect.getTextTrim();
            return new ConfigRedirectHandler(viewId, clazz, endConversation, rollback, message);
        }
        Element error = exception.element("http-error");
        if (error != null) {
            String errorCode = error.attributeValue("error-code");
            int code = Strings.isEmpty(errorCode) ? 500 : Integer.parseInt(errorCode);
            String message = error.getTextTrim();
            return new ConfigErrorHandler(message, endConversation, clazz, code, rollback);
        }
        return null;
    }

    public static Exceptions instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Exceptions)Component.getInstance(Exceptions.class, ScopeType.APPLICATION);
    }
}

