/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Locale;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Intercept(value=InterceptionType.NEVER)
@Scope(value=ScopeType.STATELESS)
@Name(value="org.jboss.seam.core.interpolator")
@Install(precedence=0)
public class Interpolator {
    private static final LogProvider log = Logging.getLogProvider(Interpolator.class);

    public static Interpolator instance() {
        if (Contexts.isApplicationContextActive()) {
            return (Interpolator)Component.getInstance(Interpolator.class, true);
        }
        return new Interpolator();
    }

    public String interpolate(String string, Object ... params) {
        if (params == null) {
            params = new Object[]{};
        }
        if (params.length > 10) {
            throw new IllegalArgumentException("more than 10 parameters");
        }
        if (string.indexOf(35) >= 0) {
            string = this.interpolateExpressions(string, params);
        }
        if (params.length > 0 && string.indexOf(123) >= 0) {
            string = new MessageFormat(string, Locale.instance()).format(params);
        }
        return string;
    }

    private String interpolateExpressions(String string, Object ... params) {
        StringTokenizer tokens = new StringTokenizer(string, "#{}", true);
        StringBuilder builder = new StringBuilder(string.length());
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            if ("#".equals(tok) && tokens.hasMoreTokens()) {
                String nextTok = tokens.nextToken();
                if ("{".equals(nextTok)) {
                    String expression = "#{" + tokens.nextToken() + "}";
                    try {
                        Object value = Expressions.instance().createValueBinding(expression).getValue();
                        if (value != null) {
                            builder.append(value);
                        }
                    }
                    catch (Exception e) {
                        log.warn("exception interpolating string: " + string, e);
                    }
                    tokens.nextToken();
                    continue;
                }
                try {
                    int index = Integer.parseInt(nextTok.substring(0, 1));
                    if (index >= params.length) {
                        builder.append("#").append(nextTok);
                        continue;
                    }
                    builder.append(params[index]).append(nextTok.substring(1));
                }
                catch (NumberFormatException nfe) {
                    builder.append("#").append(nextTok);
                }
                continue;
            }
            builder.append(tok);
        }
        return builder.toString();
    }
}

