/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.framework.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityQuery
extends Query<EntityManager> {
    private List resultList;
    private Object singleResult;
    private Long resultCount;
    private Map<String, String> hints;

    @Override
    public void validate() {
        super.validate();
        if (this.getEntityManager() == null) {
            throw new IllegalStateException("entityManager is null");
        }
    }

    @Override
    @Transactional
    public List getResultList() {
        if (this.resultList == null || this.isAnyParameterDirty()) {
            javax.persistence.Query query = this.createQuery();
            this.resultList = query == null ? null : query.getResultList();
        }
        return this.resultList;
    }

    @Override
    @Transactional
    public Object getSingleResult() {
        if (this.singleResult == null || this.isAnyParameterDirty()) {
            javax.persistence.Query query = this.createQuery();
            this.singleResult = query == null ? null : query.getSingleResult();
        }
        return this.singleResult;
    }

    @Override
    @Transactional
    public Long getResultCount() {
        if (this.resultCount == null || this.isAnyParameterDirty()) {
            javax.persistence.Query query = this.createCountQuery();
            this.resultCount = query == null ? null : (Long)query.getSingleResult();
        }
        return this.resultCount;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.resultCount = null;
        this.resultList = null;
        this.singleResult = null;
    }

    public EntityManager getEntityManager() {
        return (EntityManager)this.getPersistenceContext();
    }

    public void setEntityManager(EntityManager entityManager) {
        this.setPersistenceContext(entityManager);
    }

    @Override
    protected String getPersistenceContextName() {
        return "entityManager";
    }

    protected javax.persistence.Query createQuery() {
        this.parseEjbql();
        this.evaluateAllParameters();
        this.getEntityManager().joinTransaction();
        javax.persistence.Query query = this.getEntityManager().createQuery(this.getRenderedEjbql());
        this.setParameters(query, this.getQueryParameterValues(), 0);
        this.setParameters(query, this.getRestrictionParameterValues(), this.getQueryParameterValues().size());
        if (this.getFirstResult() != null) {
            query.setFirstResult(this.getFirstResult().intValue());
        }
        if (this.getMaxResults() != null) {
            query.setMaxResults(this.getMaxResults().intValue());
        }
        if (this.getHints() != null) {
            for (Map.Entry<String, String> me : this.getHints().entrySet()) {
                query.setHint(me.getKey(), (Object)me.getValue());
            }
        }
        return query;
    }

    protected javax.persistence.Query createCountQuery() {
        this.parseEjbql();
        this.evaluateAllParameters();
        this.getEntityManager().joinTransaction();
        javax.persistence.Query query = this.getEntityManager().createQuery(this.getCountEjbql());
        this.setParameters(query, this.getQueryParameterValues(), 0);
        this.setParameters(query, this.getRestrictionParameterValues(), this.getQueryParameterValues().size());
        return query;
    }

    private void setParameters(javax.persistence.Query query, List<Object> parameters, int start) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameterValue = parameters.get(i);
            if (!this.isRestrictionParameterSet(parameterValue)) continue;
            query.setParameter("p" + (start + i), parameterValue);
        }
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public void setHints(Map<String, String> hints) {
        this.hints = hints;
    }
}

