/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.annotations.ReadOnly;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.RootInterceptor;
import org.jboss.seam.intercept.RootInvocationContext;

public class JavaBeanInterceptor
extends RootInterceptor
implements MethodInterceptor {
    private static final long serialVersionUID = -771725005103740533L;
    private final Object bean;
    private final Class beanClass;
    private transient boolean dirty;

    public JavaBeanInterceptor(Object bean, Component component) {
        super(InterceptorType.ANY);
        this.bean = bean;
        this.beanClass = component.getBeanClass();
        this.init(component);
    }

    public Object intercept(Object proxy, Method method, Object[] params, MethodProxy methodProxy) throws Throwable {
        Object result;
        if (params != null && params.length == 0) {
            String methodName = method.getName();
            if ("finalize".equals(methodName)) {
                return methodProxy.invokeSuper(proxy, params);
            }
            if ("writeReplace".equals(methodName)) {
                return this;
            }
            if ("sessionDidActivate".equals(methodName)) {
                this.callPostActivate();
                return null;
            }
            if ("sessionWillPassivate".equals(methodName)) {
                this.callPrePassivate();
                return null;
            }
            if ("clearDirty".equals(methodName) && !(this.bean instanceof Mutable)) {
                boolean result2 = this.dirty;
                this.dirty = false;
                return result2;
            }
        }
        if (this.markDirty(method)) {
            this.dirty = true;
        }
        return (result = this.interceptInvocation(method, params, methodProxy)) == this.bean ? proxy : result;
    }

    private boolean markDirty(Method method) {
        return !this.getComponent().getBeanClass().isAnnotationPresent(ReadOnly.class) && !method.isAnnotationPresent(ReadOnly.class);
    }

    public void postConstruct() {
        super.postConstruct(this.bean);
        this.callPostConstruct();
    }

    private void callPostConstruct() {
        RootInvocationContext context = new RootInvocationContext(this.bean, this.getComponent().getPostConstructMethod(), new Object[0]){

            public Object proceed() throws Exception {
                JavaBeanInterceptor.this.getComponent().callPostConstructMethod(JavaBeanInterceptor.this.bean);
                return null;
            }
        };
        this.invokeAndHandle(context, EventType.POST_CONSTRUCT);
    }

    private void callPrePassivate() {
        RootInvocationContext context = new RootInvocationContext(this.bean, this.getComponent().getPrePassivateMethod(), new Object[0]){

            public Object proceed() throws Exception {
                JavaBeanInterceptor.this.getComponent().callPrePassivateMethod(JavaBeanInterceptor.this.bean);
                return null;
            }
        };
        this.invokeAndHandle(context, EventType.PRE_PASSIVATE);
    }

    private void callPostActivate() {
        RootInvocationContext context = new RootInvocationContext(this.bean, this.getComponent().getPostActivateMethod(), new Object[0]){

            public Object proceed() throws Exception {
                JavaBeanInterceptor.this.getComponent().callPostActivateMethod(JavaBeanInterceptor.this.bean);
                return null;
            }
        };
        this.invokeAndHandle(context, EventType.POST_ACTIVATE);
    }

    private Object interceptInvocation(Method method, Object[] params, MethodProxy methodProxy) throws Exception {
        return this.invoke(new RootInvocationContext(this.bean, method, params, methodProxy), EventType.AROUND_INVOKE);
    }

    Object readResolve() {
        Component comp = null;
        try {
            comp = this.getComponent();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            if (comp == null) {
                Factory proxy = Component.createProxyFactory(ComponentType.JAVA_BEAN, this.beanClass, Component.getBusinessInterfaces(this.beanClass)).newInstance();
                proxy.setCallback(0, (Callback)this);
                return proxy;
            }
            return comp.wrap(this.bean, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

