/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import javax.faces.context.FacesContext;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Exceptions;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;

@Interceptor(stateless=true, type=InterceptorType.CLIENT)
public class ExceptionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 748337911616171944L;
    private static final String OUTERMOST_EXCEPTION_INTERCEPTOR = "org.jboss.seam.outermostExceptionInterceptor";

    @AroundInvoke
    public Object handleExceptions(InvocationContext invocation) throws Exception {
        boolean outermost;
        boolean bl = outermost = Contexts.isEventContextActive() && Contexts.getEventContext().get(OUTERMOST_EXCEPTION_INTERCEPTOR) == null;
        if (outermost) {
            Contexts.getEventContext().set(OUTERMOST_EXCEPTION_INTERCEPTOR, true);
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception e) {
            if (outermost && FacesContext.getCurrentInstance() != null) {
                Object object = Exceptions.instance().handle(e);
                return object;
            }
            throw e;
        }
        finally {
            if (outermost) {
                Contexts.getEventContext().remove(OUTERMOST_EXCEPTION_INTERCEPTOR);
            }
        }
    }
}

