/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.seam.mock.IteratorEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletRequest
implements HttpServletRequest {
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private HttpSession session;
    private Map<String, String[]> headers = new HashMap<String, String[]>();
    private String principalName;
    private Set<String> principalRoles;

    public MockHttpServletRequest(HttpSession session) {
        this.session = session;
    }

    public MockHttpServletRequest(HttpSession session, String principalName, Set<String> principalRoles) {
        this.session = session;
        this.principalName = principalName;
        this.principalRoles = principalRoles;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String arg0) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String header) {
        String[] values = this.headers.get(header);
        return values == null || values.length == 0 ? null : values[0];
    }

    public Enumeration getHeaders(String header) {
        return new IteratorEnumeration(Arrays.asList((Object[])this.headers.get(header)).iterator());
    }

    public Enumeration getHeaderNames() {
        return new IteratorEnumeration(this.headers.keySet().iterator());
    }

    public int getIntHeader(String header) {
        throw new UnsupportedOperationException();
    }

    public String getMethod() {
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return this.principalRoles.contains(role);
    }

    public Principal getUserPrincipal() {
        return new Principal(){

            public String getName() {
                return MockHttpServletRequest.this.principalName;
            }
        };
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return null;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String att) {
        return this.attributes.get(att);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String param) {
        String[] values = this.parameters.get(param);
        return values == null || values.length == 0 ? null : values[0];
    }

    public Enumeration getParameterNames() {
        return new IteratorEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String param) {
        return this.parameters.get(param);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String att, Object value) {
        this.attributes.put(att, value);
    }

    public void removeAttribute(String att) {
        this.attributes.remove(att);
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }
}

