/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.security.PermissionCheck;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.security.jaas.SeamLoginModule;
import org.jboss.seam.util.UnifiedELValueBinding;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0, classDependencies={"org.drools.WorkingMemory"})
@Intercept(value=InterceptionType.NEVER)
public class Identity
implements Serializable {
    private static final long serialVersionUID = 3751659008033189259L;
    private static final String DEFAULT_JAAS_CONFIG_NAME = "default";
    private static final LogProvider log = Logging.getLogProvider(Identity.class);
    private static LoginModuleConfiguration defaultConfig = null;
    private String username;
    private String password;
    private Expressions.MethodBinding authenticateMethod;
    protected Principal principal;
    protected Subject subject;
    private WorkingMemory securityContext;

    @Create
    public void create() {
        this.subject = new Subject();
        this.initSecurityContext();
    }

    private void initSecurityContext() {
        RuleBase securityRules = (RuleBase)Component.getInstance("securityRules", true);
        if (securityRules != null) {
            this.securityContext = securityRules.newWorkingMemory(false);
        }
    }

    public static Identity instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Identity instance = (Identity)Component.getInstance(Identity.class, ScopeType.SESSION, true);
        if (instance == null) {
            throw new IllegalStateException("No Identity could be created");
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return this.getPrincipal() != null;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void checkRestriction(String expr) {
        if (!this.evaluateExpression(expr)) {
            if (!this.isLoggedIn()) {
                throw new NotLoggedInException();
            }
            throw new AuthorizationException(String.format("Authorization check failed for expression [%s]", expr));
        }
    }

    public String login() {
        try {
            this.authenticate();
            log.debug("Login successful for: " + this.getUsername());
            return "success";
        }
        catch (LoginException ex) {
            log.debug("Login failed for:" + this.getUsername(), ex);
            FacesMessages.instance().add("Login failed", new Object[0]);
            return null;
        }
    }

    public void authenticate() throws LoginException {
        this.authenticate(this.getLoginContext());
    }

    public void authenticate(LoginContext loginContext) throws LoginException {
        loginContext.login();
        this.password = null;
        this.postAuthenticate();
    }

    protected LoginContext getLoginContext() throws LoginException {
        return new LoginContext(DEFAULT_JAAS_CONFIG_NAME, this.subject, this.getCallbackHandler(this.username, this.password), this.getConfiguration());
    }

    public void logout() {
        this.username = null;
        this.password = null;
        this.principal = null;
        this.subject = new Subject();
        this.initSecurityContext();
    }

    public boolean hasRole(String role) {
        for (Group sg : this.subject.getPrincipals(Group.class)) {
            if (!"roles".equals(sg.getName())) continue;
            return sg.isMember((Principal)new SimplePrincipal(role));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(String name, String action, Object ... arg) {
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        PermissionCheck check = new PermissionCheck(name, action);
        WorkingMemory workingMemory = this.securityContext;
        synchronized (workingMemory) {
            handles.add(this.securityContext.assertObject((Object)check));
            for (int i = 0; i < arg.length; ++i) {
                if (i == 0 && arg[0] instanceof Collection) {
                    for (Object value : (Collection)arg[i]) {
                        if (this.securityContext.getFactHandle(value) != null) continue;
                        handles.add(this.securityContext.assertObject(value));
                    }
                    continue;
                }
                handles.add(this.securityContext.assertObject(arg[i]));
            }
            this.securityContext.fireAllRules();
            for (FactHandle handle : handles) {
                this.securityContext.retractObject(handle);
            }
        }
        return check.isGranted();
    }

    protected CallbackHandler getCallbackHandler(final String username, final String password) {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(username);
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i], "Unsupported callback");
                }
            }
        };
    }

    protected Configuration getConfiguration() {
        if (defaultConfig == null) {
            this.initDefaultConfig();
        }
        return defaultConfig;
    }

    private synchronized void initDefaultConfig() {
        if (defaultConfig == null) {
            defaultConfig = new LoginModuleConfiguration();
            HashMap options = new HashMap();
            AppConfigurationEntry[] entries = new AppConfigurationEntry[]{new AppConfigurationEntry(SeamLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            defaultConfig.addEntry(DEFAULT_JAAS_CONFIG_NAME, entries);
        }
    }

    protected void postAuthenticate() {
        for (Principal p : this.subject.getPrincipals()) {
            if (p instanceof Group && "roles".equals(((Group)p).getName())) {
                Enumeration e = ((Group)p).members();
                while (e.hasMoreElements()) {
                    Principal role = (Principal)e.nextElement();
                    this.securityContext.assertObject((Object)new Role(role.getName()));
                }
            } else {
                if (this.principal == null) {
                    this.principal = p;
                }
                this.securityContext.assertObject((Object)p);
            }
            Events.instance().raiseEvent("org.jboss.seam.postAuthenticate", new Object[0]);
        }
    }

    protected boolean evaluateExpression(String expr) {
        return (Boolean)new UnifiedELValueBinding(expr).getValue(FacesContext.getCurrentInstance());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public WorkingMemory getSecurityContext() {
        return this.securityContext;
    }

    public Expressions.MethodBinding getAuthenticateMethod() {
        return this.authenticateMethod;
    }

    public void setAuthenticateMethod(Expressions.MethodBinding authMethod) {
        this.authenticateMethod = authMethod;
    }

    private class LoginModuleConfiguration
    extends Configuration {
        private Map<String, AppConfigurationEntry[]> entries = new HashMap<String, AppConfigurationEntry[]>();

        private LoginModuleConfiguration() {
        }

        public void addEntry(String name, AppConfigurationEntry[] entry) {
            this.entries.put(name, entry);
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.entries.get(name);
        }

        public void refresh() {
        }
    }
}

