/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamLoginModule
implements LoginModule {
    private static final String OPTS_PARAM_TYPES = "paramTypes";
    private static final LogProvider log = Logging.getLogProvider(SeamLoginModule.class);
    protected Set<String> roles = new HashSet<String>();
    protected Subject subject;
    protected Map<String, ?> options;
    protected CallbackHandler callbackHandler;
    protected String username;

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(new SimplePrincipal(this.username));
        SimpleGroup roleGroup = new SimpleGroup("roles");
        for (String role : this.roles) {
            roleGroup.addMember(new SimplePrincipal(role));
        }
        this.subject.getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.options = options;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Expressions.MethodBinding mb = Identity.instance().getAuthenticateMethod();
        Object[] params = null;
        try {
            params = this.getLoginParams();
        }
        catch (Exception e) {
            log.error("Error logging in", e);
            throw new LoginException(e.getMessage());
        }
        try {
            return (Boolean)mb.invoke(this.getLoginParamTypes(), params);
        }
        catch (RuntimeException ex) {
            log.error("Error invoking login method", ex);
            return false;
        }
        catch (ClassNotFoundException ex) {
            log.error("Error determining parameter types", ex);
            return false;
        }
    }

    public Class[] getLoginParamTypes() throws ClassNotFoundException {
        if (!this.options.containsKey(OPTS_PARAM_TYPES)) {
            return new Class[]{String.class, String.class, Set.class};
        }
        String[] paramTypes = ((String)this.options.get(OPTS_PARAM_TYPES)).split("[,]");
        Class[] types = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = Reflections.classForName(paramTypes[i].trim());
        }
        return types;
    }

    public Object[] getLoginParams() throws Exception {
        NameCallback cbName = new NameCallback("Enter username");
        PasswordCallback cbPassword = new PasswordCallback("Enter password", false);
        this.callbackHandler.handle(new Callback[]{cbName, cbPassword});
        this.username = cbName.getName();
        return new Object[]{this.username, new String(cbPassword.getPassword()), this.roles};
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

