/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequest
extends HttpServletRequestWrapper {
    public static final String WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    private HttpServletRequest request;
    private Map<String, PartWrapper> parameters;
    private static final String FILE_CONTENT_TYPE = "Content-Type";
    private static final String FILE_NAME = "filename";
    private byte[] boundaryMarker;
    private InputStream input;
    private byte[] buffer;
    private int pos;
    private int totalRead;
    private int bufferEnd;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final Pattern PARAM_VALUE_PATTERN = Pattern.compile("^\\s*([^\\s=]+)\\s*[=:]\\s*([^\\s]+)\\s*$");

    public MultipartRequest(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    private void parseRequest() {
        this.parameters = new HashMap<String, PartWrapper>();
        this.boundaryMarker = this.getBoundary(this.request.getContentType());
        if (this.boundaryMarker == null) {
            throw new RuntimeException("the request was rejected because no multipart boundary was found");
        }
        try {
            this.buffer = new byte[4096];
            this.bufferEnd = 0;
            this.input = this.request.getInputStream();
            this.pos = 0;
            this.fillBuffer();
            byte[] boundary = this.readNextBoundary();
            while (boundary != null || this.fillBuffer()) {
                if (boundary != null) {
                    this.parseBoundary(boundary);
                }
                boundary = this.readNextBoundary();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseBoundary(byte[] boundary) {
        PartWrapper entry = new PartWrapper();
        int start = 0;
        for (int i = 0; i < boundary.length; ++i) {
            if (!this.checkSequence(boundary, i, CR_LF)) continue;
            if (start < i - CR_LF.length) {
                String line = new String(boundary, start, i - CR_LF.length - start);
                this.parseParams(line, ";", entry.getParams());
                start = i;
            }
            if (!this.checkSequence(boundary, i + CR_LF.length, CR_LF)) continue;
            start = i + CR_LF.length;
            break;
        }
        for (String key : entry.getParams().keySet()) {
            String s;
            Object val = entry.getParams().get(key);
            if (!(val instanceof String) || (s = (String)entry.getParams().get(key)) == null) continue;
            if (entry.getContentType() == null && FILE_CONTENT_TYPE.equalsIgnoreCase(key)) {
                entry.setContentType(s);
                continue;
            }
            if (entry.getFileName() != null || !FILE_NAME.equalsIgnoreCase(key)) continue;
            entry.setFileName(s);
        }
        byte[] data = new byte[boundary.length - start];
        System.arraycopy(boundary, start, data, 0, data.length);
        entry.setData(data);
        if (entry.getParams().containsKey("name")) {
            this.parameters.put((String)entry.getParams().get("name"), entry);
        }
    }

    private boolean fillBuffer() throws IOException {
        int read;
        if (this.totalRead >= this.request.getContentLength()) {
            return false;
        }
        if (this.pos > 0) {
            System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.bufferEnd - this.pos);
            this.bufferEnd -= this.pos;
            this.pos = 0;
        }
        if (this.pos == 0 && this.bufferEnd >= this.buffer.length - 1) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        if ((read = this.input.read(this.buffer, this.bufferEnd, this.buffer.length - this.bufferEnd)) != -1) {
            this.bufferEnd += read;
            this.totalRead += read;
        }
        return read != -1;
    }

    private byte[] readNextBoundary() throws IOException {
        int boundaryStart = -1;
        for (int i = this.pos; i < this.bufferEnd; ++i) {
            if (boundaryStart == -1 && this.checkSequence(this.buffer, i, this.boundaryMarker) && this.checkSequence(this.buffer, i + CR_LF.length, CR_LF)) {
                boundaryStart = i + CR_LF.length;
                continue;
            }
            if (boundaryStart == -1 || !this.checkSequence(this.buffer, i, this.boundaryMarker)) continue;
            byte[] boundary = new byte[i - this.boundaryMarker.length - boundaryStart - 4];
            System.arraycopy(this.buffer, boundaryStart, boundary, 0, boundary.length);
            this.pos = i - this.boundaryMarker.length;
            return boundary;
        }
        return null;
    }

    private boolean checkSequence(byte[] data, int pos, byte[] seq) {
        if (pos - seq.length < 0 || pos > data.length) {
            return false;
        }
        for (int i = 0; i < seq.length; ++i) {
            if (data[pos - seq.length + i] == seq[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] getBoundary(String contentType) {
        Map<String, Object> params = this.parseParams(contentType, ";");
        String boundaryStr = (String)params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            return boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return boundaryStr.getBytes();
        }
    }

    private void parseParams(String paramStr, String separator, Map<String, Object> target) {
        String[] parts;
        for (String part : parts = paramStr.split("[" + separator + "]")) {
            Matcher m = PARAM_VALUE_PATTERN.matcher(part);
            if (!m.matches()) continue;
            String key = m.group(1);
            String value = m.group(2);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (target.containsKey(key)) {
                ArrayList<Object> vals;
                Object v = target.get(key);
                if (v instanceof List) {
                    ((List)v).add(value);
                    continue;
                }
                if (v instanceof String) {
                    vals = new ArrayList<Object>();
                    vals.add((String)v);
                    vals.add(value);
                    target.put(key, value);
                    continue;
                }
                vals = new ArrayList();
                vals.add(v);
                vals.add(value);
                target.put(key, value);
                continue;
            }
            target.put(key, value);
        }
    }

    private Map<String, Object> parseParams(String paramStr, String separator) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        this.parseParams(paramStr, separator, target);
        return target;
    }

    public Enumeration getParameterNames() {
        if (this.parameters == null) {
            this.parseRequest();
        }
        return Collections.enumeration(this.parameters.keySet());
    }

    public byte[] getFileBytes(String name) {
        PartWrapper wrapper;
        if (this.parameters == null) {
            this.parseRequest();
        }
        return (wrapper = this.parameters.get(name)) != null ? wrapper.getData() : null;
    }

    public String getFileContentType(String name) {
        PartWrapper wrapper;
        if (this.parameters == null) {
            this.parseRequest();
        }
        return (wrapper = this.parameters.get(name)) != null ? wrapper.getContentType() : null;
    }

    public String getFileName(String name) {
        PartWrapper wrapper;
        if (this.parameters == null) {
            this.parseRequest();
        }
        return (wrapper = this.parameters.get(name)) != null ? wrapper.getFileName() : null;
    }

    public String getParameter(String name) {
        PartWrapper wrapper;
        if (this.parameters == null) {
            this.parseRequest();
        }
        return (wrapper = this.parameters.get(name)) != null ? new String(wrapper.getData()) : super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] stringArray;
        PartWrapper wrapper;
        if (this.parameters == null) {
            this.parseRequest();
        }
        if ((wrapper = this.parameters.get(name)) != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = new String(this.parameters.get(name).getData());
        } else {
            stringArray = super.getParameterValues(name);
        }
        return stringArray;
    }

    public Map getParameterMap() {
        if (this.parameters == null) {
            this.parseRequest();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (String name : this.parameters.keySet()) {
            PartWrapper w = this.parameters.get(name);
            params.put(name, new String(w.getData()));
        }
        return params;
    }

    public Object getAttribute(String string) {
        return super.getAttribute(string);
    }

    public String getContentType() {
        return WWW_FORM_URLENCODED_TYPE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PartWrapper {
        private Map<String, Object> params = new HashMap<String, Object>();
        private byte[] data;
        private String contentType;
        private String fileName;

        public Map<String, Object> getParams() {
            return this.params;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }
}

