/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import javax.faces.event.PhaseId;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class SeamServletFilter
implements Filter {
    private static final LogProvider log = Logging.getLogProvider(SeamServletFilter.class);
    private ServletContext servletContext;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("beginning request");
        HttpSession session = ((HttpServletRequest)request).getSession(true);
        Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
        Lifecycle.setServletRequest(request);
        Lifecycle.beginRequest(this.servletContext, session, request);
        Manager.instance().restoreConversation(request.getParameterMap());
        Lifecycle.resumeConversation(session);
        Manager.instance().handleConversationPropagation(request.getParameterMap());
        try {
            chain.doFilter(request, response);
            Manager.instance().endRequest(ContextAdaptor.getSession(session));
            Lifecycle.endRequest(session);
        }
        catch (Exception e) {
            Lifecycle.endRequest();
            log.error("ended request due to exception", e);
            throw new ServletException((Throwable)e);
        }
        finally {
            Lifecycle.setServletRequest(null);
            Lifecycle.setPhaseId(null);
            log.debug("ended request");
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
    }
}

