/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.text;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.text.SeamTextParserTokenTypes;

public class SeamTextParser
extends LLkParser
implements SeamTextParserTokenTypes {
    private Set htmlElements = new HashSet<String>(Arrays.asList("a", "p", "quote", "code", "pre", "table", "tr", "td", "th", "ul", "ol", "li", "b", "i", "u", "tt", "del", "em", "hr", "br", "div", "span", "h1", "h2", "h3", "h4", "img"));
    private Set htmlAttributes = new HashSet<String>(Arrays.asList("src", "href", "lang", "class", "id"));
    private StringBuilder mainBuilder;
    private StringBuilder builder = this.mainBuilder = new StringBuilder();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "WORD", "PUNCTUATION", "ESCAPE", "STAR", "SLASH", "BAR", "HAT", "MINUS", "PLUS", "EQ", "HASH", "TWIDDLE", "UNDERSCORE", "SEMICOLON", "OPEN", "CLOSE", "QUOTE", "GT", "LT", "DOUBLEQUOTE", "AMPERSAND", "BACKTICK", "SPACE", "NEWLINE"};
    public static final BitSet _tokenSet_0 = new BitSet(SeamTextParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SeamTextParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(SeamTextParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(SeamTextParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(SeamTextParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(SeamTextParser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(SeamTextParser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(SeamTextParser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(SeamTextParser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(SeamTextParser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(SeamTextParser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(SeamTextParser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(SeamTextParser.mk_tokenSet_12());

    public String toString() {
        return this.builder.toString();
    }

    private void append(String ... strings) {
        for (String string : strings) {
            this.builder.append(string);
        }
    }

    private static boolean hasMultiple(String string, char c) {
        return string.indexOf(c) != string.lastIndexOf(c);
    }

    private void validateElement(Token t) throws NoViableAltException {
        if (!this.htmlElements.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void validateAttribute(Token t) throws NoViableAltException {
        if (!this.htmlAttributes.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void beginCapture() {
        this.builder = new StringBuilder();
    }

    private String endCapture() {
        String result = this.builder.toString();
        this.builder = this.mainBuilder;
        return result;
    }

    protected String linkUrl(String linkText) {
        return linkText.trim();
    }

    protected String linkDescription(String descriptionText, String linkText) {
        return descriptionText.toString().trim().length() > 0 ? descriptionText : linkText;
    }

    protected String linkClass(String linkText) {
        return "seamTextLink";
    }

    protected SeamTextParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 4);
    }

    protected SeamTextParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenStream lexer) {
        this(lexer, 4);
    }

    public SeamTextParser(ParserSharedInputState state) {
        super(state, 4);
        this.tokenNames = _tokenNames;
    }

    public final void startRule() throws RecognitionException, TokenStreamException {
        try {
            while (this.LA(1) == 17 || this.LA(1) == 27) {
                this.newline();
            }
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 18: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    switch (this.LA(1)) {
                        case 12: {
                            this.heading();
                            while (this.LA(1) == 17 || this.LA(1) == 27) {
                                this.newline();
                            }
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 18: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.text();
                    while (this.LA(1) == 12) {
                        this.heading();
                        while (this.LA(1) == 17 || this.LA(1) == 27) {
                            this.newline();
                        }
                        this.text();
                    }
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
    }

    public final void newline() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 17: {
                    this.match(17);
                    this.append("\n");
                    break;
                }
                case 27: {
                    this.simpleNewline();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void heading() throws RecognitionException, TokenStreamException {
        try {
            if (this.LA(1) == 12 && _tokenSet_2.member(this.LA(2))) {
                this.h1();
            } else if (this.LA(1) == 12 && this.LA(2) == 12 && _tokenSet_2.member(this.LA(3))) {
                this.h2();
            } else if (this.LA(1) == 12 && this.LA(2) == 12 && this.LA(3) == 12 && _tokenSet_2.member(this.LA(4))) {
                this.h3();
            } else if (this.LA(1) == 12 && this.LA(2) == 12 && this.LA(3) == 12 && this.LA(4) == 12) {
                this.h4();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.newlineOrEof();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
    }

    public final void text() throws RecognitionException, TokenStreamException {
        try {
            int _cnt17 = 0;
            while (true) {
                if (!_tokenSet_4.member(this.LA(1))) {
                    if (_cnt17 < 1) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break;
                }
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 16: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.paragraph();
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 23: 
                    case 25: {
                        this.special();
                        break;
                    }
                    case 22: {
                        this.html();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                while (this.LA(1) == 17 || this.LA(1) == 27) {
                    this.newline();
                }
                ++_cnt17;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_5);
        }
    }

    public final void paragraph() throws RecognitionException, TokenStreamException {
        try {
            this.append("<p>\n");
            int _cnt22 = 0;
            while (true) {
                if (!_tokenSet_2.member(this.LA(1))) {
                    if (_cnt22 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.line();
                this.newlineOrEof();
                ++_cnt22;
            }
            this.append("</p>\n");
            this.newlineOrEof();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void special() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 25: {
                    this.preformatted();
                    break;
                }
                case 23: {
                    this.quoted();
                    break;
                }
                case 13: 
                case 14: {
                    this.list();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.newlineOrEof();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void html() throws RecognitionException, TokenStreamException {
        try {
            this.openTag();
            while (this.LA(1) == 26) {
                this.attribute();
            }
            switch (this.LA(1)) {
                case 21: {
                    this.beforeBody();
                    this.body();
                    this.closeTagWithBody();
                    break;
                }
                case 8: {
                    this.closeTagWithNoBody();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void preformatted() throws RecognitionException, TokenStreamException {
        try {
            this.match(25);
            this.append("<pre>");
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: {
                        this.word();
                        continue block11;
                    }
                    case 5: {
                        this.punctuation();
                        continue block11;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.specialChars();
                        continue block11;
                    }
                    case 18: 
                    case 19: {
                        this.moreSpecialChars();
                        continue block11;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: {
                        this.htmlSpecialChars();
                        continue block11;
                    }
                    case 26: {
                        this.space();
                        continue block11;
                    }
                    case 27: {
                        this.simpleNewline();
                        continue block11;
                    }
                }
                break;
            }
            this.match(25);
            this.append("</pre>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void quoted() throws RecognitionException, TokenStreamException {
        try {
            this.match(23);
            this.append("<quote>");
            block10: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        continue block10;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 16: {
                        this.formatted();
                        continue block10;
                    }
                    case 25: {
                        this.preformatted();
                        continue block10;
                    }
                    case 22: {
                        this.html();
                        continue block10;
                    }
                    case 13: 
                    case 14: {
                        this.list();
                        this.newline();
                        continue block10;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        continue block10;
                    }
                }
                break;
            }
            this.match(23);
            this.append("</quote>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void list() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 14: {
                    this.olist();
                    break;
                }
                case 13: {
                    this.ulist();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void newlineOrEof() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 17: 
                case 27: {
                    this.newline();
                    break;
                }
                case 1: {
                    this.match(1);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void line() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 18: 
                case 24: 
                case 26: {
                    this.plain();
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: {
                    this.formatted();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            block13: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        continue block13;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 16: {
                        this.formatted();
                        continue block13;
                    }
                    case 25: {
                        this.preformatted();
                        continue block13;
                    }
                    case 23: {
                        this.quoted();
                        continue block13;
                    }
                    case 22: {
                        this.html();
                        continue block13;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void plain() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 4: {
                    this.word();
                    break;
                }
                case 5: {
                    this.punctuation();
                    break;
                }
                case 6: {
                    this.escape();
                    break;
                }
                case 26: {
                    this.space();
                    break;
                }
                case 18: {
                    this.link();
                    break;
                }
                case 24: {
                    this.entity();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void formatted() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 7: {
                    this.bold();
                    break;
                }
                case 16: {
                    this.underline();
                    break;
                }
                case 8: {
                    this.italic();
                    break;
                }
                case 9: {
                    this.monospace();
                    break;
                }
                case 10: {
                    this.superscript();
                    break;
                }
                case 11: {
                    this.deleted();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void bold() throws RecognitionException, TokenStreamException {
        try {
            this.match(7);
            this.append("<b>");
            int _cnt44 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        break;
                    }
                    case 16: {
                        this.underline();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 11: {
                        this.deleted();
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt44 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt44;
            }
            this.match(7);
            this.append("</b>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void underline() throws RecognitionException, TokenStreamException {
        try {
            this.match(16);
            this.append("<u>");
            int _cnt47 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 11: {
                        this.deleted();
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt47 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt47;
            }
            this.match(16);
            this.append("</u>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void italic() throws RecognitionException, TokenStreamException {
        try {
            this.match(8);
            this.append("<i>");
            int _cnt50 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 16: {
                        this.underline();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 11: {
                        this.deleted();
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt50 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt50;
            }
            this.match(8);
            this.append("</i>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void monospace() throws RecognitionException, TokenStreamException {
        try {
            this.match(9);
            this.append("<tt>");
            int _cnt53 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 16: {
                        this.underline();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 11: {
                        this.deleted();
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt53 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt53;
            }
            this.match(9);
            this.append("</tt>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void superscript() throws RecognitionException, TokenStreamException {
        try {
            this.match(10);
            this.append("<sup>");
            int _cnt56 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 16: {
                        this.underline();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 11: {
                        this.deleted();
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt56 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt56;
            }
            this.match(10);
            this.append("</sup>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void deleted() throws RecognitionException, TokenStreamException {
        try {
            this.match(11);
            this.append("<del>");
            int _cnt59 = 0;
            block11: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        break;
                    }
                    case 7: {
                        this.bold();
                        break;
                    }
                    case 16: {
                        this.underline();
                        break;
                    }
                    case 8: {
                        this.italic();
                        break;
                    }
                    case 9: {
                        this.monospace();
                        break;
                    }
                    case 10: {
                        this.superscript();
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        break;
                    }
                    default: {
                        if (_cnt59 >= 1) break block11;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                ++_cnt59;
            }
            this.match(11);
            this.append("</del>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void word() throws RecognitionException, TokenStreamException {
        Token w = null;
        try {
            w = this.LT(1);
            this.match(4);
            this.append(w.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void punctuation() throws RecognitionException, TokenStreamException {
        Token p = null;
        try {
            p = this.LT(1);
            this.match(5);
            this.append(p.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void escape() throws RecognitionException, TokenStreamException {
        try {
            this.match(6);
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.specialChars();
                    break;
                }
                case 18: 
                case 19: {
                    this.moreSpecialChars();
                    break;
                }
                case 20: {
                    this.evenMoreSpecialChars();
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.htmlSpecialChars();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void space() throws RecognitionException, TokenStreamException {
        Token s = null;
        try {
            s = this.LT(1);
            this.match(26);
            this.append(s.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void link() throws RecognitionException, TokenStreamException {
        try {
            this.match(18);
            this.beginCapture();
            while (_tokenSet_9.member(this.LA(1))) {
                this.plain();
            }
            String text = this.endCapture();
            this.match(13);
            this.match(21);
            this.beginCapture();
            this.attributeValue();
            String link = this.endCapture();
            this.append("<a class=\"");
            this.append(this.linkClass(link));
            this.append("\" href=\"");
            this.append(this.linkUrl(link));
            this.append("\">");
            this.append(this.linkDescription(text, link));
            this.append("</a>");
            this.match(19);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void entity() throws RecognitionException, TokenStreamException {
        try {
            this.match(24);
            this.append("&amp;");
            switch (this.LA(1)) {
                case 14: {
                    this.match(14);
                    this.append("#");
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.word();
            this.match(17);
            this.append(";");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void specialChars() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token sl = null;
        Token b = null;
        Token h = null;
        Token m = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        Token sc = null;
        try {
            switch (this.LA(1)) {
                case 7: {
                    st = this.LT(1);
                    this.match(7);
                    this.append(st.getText());
                    break;
                }
                case 8: {
                    sl = this.LT(1);
                    this.match(8);
                    this.append(sl.getText());
                    break;
                }
                case 9: {
                    b = this.LT(1);
                    this.match(9);
                    this.append(b.getText());
                    break;
                }
                case 10: {
                    h = this.LT(1);
                    this.match(10);
                    this.append(h.getText());
                    break;
                }
                case 11: {
                    m = this.LT(1);
                    this.match(11);
                    this.append(m.getText());
                    break;
                }
                case 12: {
                    p = this.LT(1);
                    this.match(12);
                    this.append(p.getText());
                    break;
                }
                case 13: {
                    eq = this.LT(1);
                    this.match(13);
                    this.append(eq.getText());
                    break;
                }
                case 14: {
                    hh = this.LT(1);
                    this.match(14);
                    this.append(hh.getText());
                    break;
                }
                case 6: {
                    e = this.LT(1);
                    this.match(6);
                    this.append(e.getText());
                    break;
                }
                case 15: {
                    t = this.LT(1);
                    this.match(15);
                    this.append(t.getText());
                    break;
                }
                case 16: {
                    u = this.LT(1);
                    this.match(16);
                    this.append(u.getText());
                    break;
                }
                case 17: {
                    sc = this.LT(1);
                    this.match(17);
                    this.append(sc.getText());
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void moreSpecialChars() throws RecognitionException, TokenStreamException {
        Token o = null;
        Token c = null;
        try {
            switch (this.LA(1)) {
                case 18: {
                    o = this.LT(1);
                    this.match(18);
                    this.append(o.getText());
                    break;
                }
                case 19: {
                    c = this.LT(1);
                    this.match(19);
                    this.append(c.getText());
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void evenMoreSpecialChars() throws RecognitionException, TokenStreamException {
        Token q = null;
        try {
            q = this.LT(1);
            this.match(20);
            this.append(q.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
    }

    public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
        try {
            switch (this.LA(1)) {
                case 21: {
                    this.match(21);
                    this.append("&gt;");
                    break;
                }
                case 22: {
                    this.match(22);
                    this.append("&lt;");
                    break;
                }
                case 23: {
                    this.match(23);
                    this.append("&quot;");
                    break;
                }
                case 24: {
                    this.match(24);
                    this.append("&amp;");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        try {
            block9: while (true) {
                switch (this.LA(1)) {
                    case 24: {
                        this.match(24);
                        this.append("&amp;");
                        continue block9;
                    }
                    case 4: {
                        this.word();
                        continue block9;
                    }
                    case 5: {
                        this.punctuation();
                        continue block9;
                    }
                    case 26: {
                        this.space();
                        continue block9;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.specialChars();
                        continue block9;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_10);
        }
    }

    public final void simpleNewline() throws RecognitionException, TokenStreamException {
        Token n = null;
        try {
            n = this.LT(1);
            this.match(27);
            this.append(n.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
    }

    public final void h1() throws RecognitionException, TokenStreamException {
        try {
            this.match(12);
            this.append("<h1>");
            this.line();
            this.append("</h1>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void h2() throws RecognitionException, TokenStreamException {
        try {
            this.match(12);
            this.match(12);
            this.append("<h2>");
            this.line();
            this.append("</h2>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void h3() throws RecognitionException, TokenStreamException {
        try {
            this.match(12);
            this.match(12);
            this.match(12);
            this.append("<h3>");
            this.line();
            this.append("</h3>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void h4() throws RecognitionException, TokenStreamException {
        try {
            this.match(12);
            this.match(12);
            this.match(12);
            this.match(12);
            this.append("<h4>");
            this.line();
            this.append("</h4>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void olist() throws RecognitionException, TokenStreamException {
        try {
            this.append("<ol>\n");
            int _cnt76 = 0;
            while (true) {
                if (this.LA(1) != 14) {
                    if (_cnt76 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.olistLine();
                this.newlineOrEof();
                ++_cnt76;
            }
            this.append("</ol>\n");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void ulist() throws RecognitionException, TokenStreamException {
        try {
            this.append("<ul>\n");
            int _cnt80 = 0;
            while (true) {
                if (this.LA(1) != 13) {
                    if (_cnt80 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.ulistLine();
                this.newlineOrEof();
                ++_cnt80;
            }
            this.append("</ul>\n");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void olistLine() throws RecognitionException, TokenStreamException {
        try {
            this.match(14);
            this.append("<li>");
            this.line();
            this.append("</li>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void ulistLine() throws RecognitionException, TokenStreamException {
        try {
            this.match(13);
            this.append("<li>");
            this.line();
            this.append("</li>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
    }

    public final void openTag() throws RecognitionException, TokenStreamException {
        Token name = null;
        try {
            this.match(22);
            name = this.LT(1);
            this.match(4);
            this.validateElement(name);
            this.append("<");
            this.append(name.getText());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_11);
        }
    }

    public final void attribute() throws RecognitionException, TokenStreamException {
        Token att = null;
        try {
            this.space();
            att = this.LT(1);
            this.match(4);
            this.match(13);
            this.match(23);
            this.validateAttribute(att);
            this.append(att.getText());
            this.append("=\"");
            this.attributeValue();
            this.match(23);
            this.append("\"");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_11);
        }
    }

    public final void beforeBody() throws RecognitionException, TokenStreamException {
        try {
            this.match(21);
            this.append(">");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
    }

    public final void body() throws RecognitionException, TokenStreamException {
        try {
            block10: while (true) {
                switch (this.LA(1)) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 18: 
                    case 24: 
                    case 26: {
                        this.plain();
                        continue block10;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 16: {
                        this.formatted();
                        continue block10;
                    }
                    case 25: {
                        this.preformatted();
                        continue block10;
                    }
                    case 23: {
                        this.quoted();
                        continue block10;
                    }
                    case 13: 
                    case 14: {
                        this.list();
                        this.newline();
                        continue block10;
                    }
                    case 17: 
                    case 27: {
                        this.newline();
                        continue block10;
                    }
                }
                if (this.LA(1) == 22 && this.LA(2) == 4) {
                    this.html();
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_12);
        }
    }

    public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
        Token name = null;
        try {
            this.match(22);
            this.match(8);
            name = this.LT(1);
            this.match(4);
            this.match(21);
            this.append("</");
            this.append(name.getText());
            this.append(">");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
        try {
            this.match(8);
            this.match(21);
            this.append("/>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{264732658L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{0x5050FF0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{264728560L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{130379760L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{4098L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{264728562L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{0x8020002L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{0xFEFFFF2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{84148336L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{0x880000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{69206272L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[]{0x400000L, 0L};
        return data;
    }
}

