/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.io.InputStream;
import java.io.Serializable;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Resources;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final long serialVersionUID = -4553926061006790714L;
    private static final LogProvider log = Logging.getLogProvider(DTDEntityResolver.class);
    private static final String SEAM_NAMESPACE = "http://jboss.com/products/seam/";
    private static final String USER_NAMESPACE = "classpath://";

    /*
     * Enabled aggressive block sorting
     */
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId == null) return null;
        log.debug("trying to resolve system-id [" + systemId + "]");
        if (systemId.startsWith(SEAM_NAMESPACE)) {
            log.debug("recognized Seam namespace; attempting to resolve on classpath under org/jboss/seam/");
            String path = "org/jboss/seam/" + systemId.substring(SEAM_NAMESPACE.length());
            InputStream dtdStream = this.resolveInSeamNamespace(path);
            if (dtdStream == null) {
                log.debug("unable to locate [" + systemId + "] on classpath");
                return null;
            }
            log.debug("located [" + systemId + "] in classpath");
            InputSource source = new InputSource(dtdStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        if (!systemId.startsWith(USER_NAMESPACE)) return null;
        log.debug("recognized local namespace; attempting to resolve on classpath");
        String path = systemId.substring(USER_NAMESPACE.length());
        InputStream stream = this.resolveInLocalNamespace(path);
        if (stream == null) {
            log.debug("unable to locate [" + systemId + "] on classpath");
            return null;
        }
        log.debug("located [" + systemId + "] in classpath");
        InputSource source = new InputSource(stream);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    protected InputStream resolveInSeamNamespace(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    protected InputStream resolveInLocalNamespace(String path) {
        try {
            return Resources.getResourceAsStream(path);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

