/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.contexts.ApplicationContext;
import org.jboss.seam.core.Init;
import org.jboss.seam.servlet.ServletApplicationMap;
import org.jboss.seam.web.AbstractResource;

public class SeamResourceServlet
extends HttpServlet {
    private ServletContext context;
    private Map<String, AbstractResource> providers = new HashMap<String, AbstractResource>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
        this.loadResourceProviders();
    }

    protected void loadResourceProviders() {
        ApplicationContext tempApplicationContext = new ApplicationContext(new ServletApplicationMap(this.context));
        Init init = (Init)tempApplicationContext.get(Init.class);
        for (String name : init.getResourceProviders()) {
            AbstractResource provider = (AbstractResource)tempApplicationContext.get(name);
            if (provider == null) continue;
            provider.setServletContext(this.context);
            this.providers.put(provider.getResourcePath(), provider);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String prefix = request.getContextPath() + request.getServletPath();
        if (request.getRequestURI().startsWith(prefix)) {
            AbstractResource provider;
            String path = request.getRequestURI().replaceFirst(prefix, "");
            int index = path.indexOf(47, 1);
            if (index != -1) {
                path = path.substring(0, index);
            }
            if ((provider = this.providers.get(path)) != null) {
                provider.getResource(request, response);
            } else {
                response.sendError(404);
            }
        } else {
            response.sendError(404);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

