/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.SecurityFunctions;

public class SeamFunctionMapper
extends FunctionMapper {
    private static Map<String, Method> methodCache = new HashMap<String, Method>();
    private static final LogProvider log = Logging.getLogProvider(SeamFunctionMapper.class);
    private FunctionMapper functionMapper;

    public SeamFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    public Method resolveFunction(String prefix, String localName) {
        if ("s".equals(prefix)) {
            return methodCache.get(localName);
        }
        if (this.functionMapper != null) {
            return this.functionMapper.resolveFunction(prefix, localName);
        }
        return null;
    }

    private static void cacheMethod(String localName, Class cls, String name, Class[] params) {
        try {
            Method m = cls.getMethod(name, params);
            methodCache.put(localName, m);
        }
        catch (NoSuchMethodException ex) {
            log.warn(String.format("Method %s.%s could not be cached", cls.getName(), name));
        }
    }

    static {
        SeamFunctionMapper.cacheMethod("hasPermission", SecurityFunctions.class, "hasPermission", new Class[]{String.class, String.class, Object.class});
        SeamFunctionMapper.cacheMethod("hasRole", SecurityFunctions.class, "hasRole", new Class[]{String.class});
    }
}

