/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.jboss.seam.el.EL;
import org.jboss.seam.mock.MockRenderKit;

public class MockFacesContext
extends FacesContext {
    private UIViewRoot viewRoot;
    private final Map<FacesMessage, String> messages = new LinkedHashMap<FacesMessage, String>();
    private ExternalContext externalContext;
    private ResponseWriter responseWriter;
    private RenderKitFactory renderKitFactory;
    private ELContext elContext;
    private Application application;
    private boolean renderResponse;
    private boolean responseComplete;

    public MockFacesContext(ExternalContext externalContext, Application application) {
        this.externalContext = externalContext;
        this.application = application;
    }

    public MockFacesContext(ExternalContext externalContext) {
        this.application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.externalContext = externalContext;
    }

    public Application getApplication() {
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        return this.messages.values().iterator();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        FacesMessage.Severity max = null;
        for (FacesMessage msg : this.messages.keySet()) {
            if (max != null && msg.getSeverity().compareTo((Object)max) <= 0) continue;
            max = msg.getSeverity();
        }
        return max;
    }

    public Iterator getMessages() {
        return this.messages.keySet().iterator();
    }

    public Iterator getMessages(String clientId) {
        ArrayList<FacesMessage> list = new ArrayList<FacesMessage>();
        for (Map.Entry<FacesMessage, String> entry : this.messages.entrySet()) {
            String messageId = entry.getValue();
            if (!this.idsAreEqual(clientId, messageId)) continue;
            list.add(entry.getKey());
        }
        return list.iterator();
    }

    private boolean idsAreEqual(String clientId, String messageId) {
        return clientId == null && messageId == null || clientId != null && clientId.equals(messageId);
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null || this.getViewRoot().getRenderKitId() == null) {
            return MockRenderKit.INSTANCE;
        }
        return this.renderKitFactory.getRenderKit((FacesContext)this, this.getViewRoot().getRenderKitId());
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        throw new UnsupportedOperationException();
    }

    public void setResponseStream(ResponseStream stream) {
        throw new UnsupportedOperationException();
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter writer) {
        this.responseWriter = writer;
    }

    public UIViewRoot getViewRoot() {
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot vr) {
        this.viewRoot = vr;
    }

    public void addMessage(String clientId, FacesMessage msg) {
        this.messages.put(msg, clientId);
    }

    public void release() {
        MockFacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public MockFacesContext setCurrent() {
        MockFacesContext.setCurrentInstance((FacesContext)this);
        return this;
    }

    public MockFacesContext createViewRoot() {
        this.viewRoot = new UIViewRoot();
        this.viewRoot.setRenderKitId(this.getApplication().getViewHandler().calculateRenderKitId((FacesContext)this));
        return this;
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = EL.createELContext(EL.EL_CONTEXT, this.getApplication().getELResolver());
            this.elContext.putContext(FacesContext.class, (Object)this);
        }
        return this.elContext;
    }
}

